/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job;

import alluxio.RestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.ServerConfiguration;
import alluxio.grpc.ListAllPOptions;
import alluxio.job.JobConfig;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.master.AlluxioJobMasterProcess;
import alluxio.master.job.JobMaster;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="master/job")
@Produces(value={"application/json"})
@Api(value="/master")
public final class JobMasterClientRestServiceHandler {
    private JobMaster mJobMaster;

    public JobMasterClientRestServiceHandler(@Context ServletContext context) {
        this.mJobMaster = ((AlluxioJobMasterProcess)((Object)context.getAttribute("Alluxio Job Master"))).getJobMaster();
    }

    @GET
    @Path(value="service_name")
    public Response getServiceName() {
        return RestUtils.call((RestUtils.RestCallable)new RestUtils.RestCallable<String>(){

            public String call() throws Exception {
                return "JobMasterClient";
            }
        }, (AlluxioConfiguration)ServerConfiguration.global());
    }

    @GET
    @Path(value="service_version")
    public Response getServiceVersion() {
        return RestUtils.call((RestUtils.RestCallable)new RestUtils.RestCallable<Integer>(){

            public Integer call() throws Exception {
                return 1;
            }
        }, (AlluxioConfiguration)ServerConfiguration.global());
    }

    @POST
    @Path(value="cancel")
    public Response cancel(final @QueryParam(value="jobId") long jobId) {
        return RestUtils.call((RestUtils.RestCallable)new RestUtils.RestCallable<Void>(){

            public Void call() throws Exception {
                JobMasterClientRestServiceHandler.this.mJobMaster.cancel(jobId);
                return null;
            }
        }, (AlluxioConfiguration)ServerConfiguration.global());
    }

    @GET
    @Path(value="get_status")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @ApiOperation(value="Gets the status of a job", response=JobInfo.class)
    public Response getStatus(final @QueryParam(value="jobId") long jobId) {
        return RestUtils.call((RestUtils.RestCallable)new RestUtils.RestCallable<JobInfo>(){

            public JobInfo call() throws Exception {
                return JobMasterClientRestServiceHandler.this.mJobMaster.getStatus(jobId);
            }
        }, (AlluxioConfiguration)ServerConfiguration.global());
    }

    @GET
    @Path(value="list")
    public Response list(final @QueryParam(value="status") List<String> statusList, final @QueryParam(value="name") String name) {
        return RestUtils.call((RestUtils.RestCallable)new RestUtils.RestCallable<List<Long>>(){

            public List<Long> call() throws Exception {
                if (statusList != null) {
                    return JobMasterClientRestServiceHandler.this.mJobMaster.list(ListAllPOptions.newBuilder().addAllStatus((Iterable)statusList.stream().map(Status::valueOf).map(Status::toProto).collect(Collectors.toList())).setName(Objects.toString(name, "")).build());
                }
                return JobMasterClientRestServiceHandler.this.mJobMaster.list(ListAllPOptions.getDefaultInstance());
            }
        }, (AlluxioConfiguration)ServerConfiguration.global());
    }

    @POST
    @Path(value="run")
    @Consumes(value={"application/json"})
    public Response run(final JobConfig jobConfig) {
        return RestUtils.call((RestUtils.RestCallable)new RestUtils.RestCallable<Long>(){

            public Long call() throws Exception {
                return JobMasterClientRestServiceHandler.this.mJobMaster.run(jobConfig);
            }
        }, (AlluxioConfiguration)ServerConfiguration.global());
    }
}

