/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.grpc.GrpcServer;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.GrpcServerBuilder;
import alluxio.grpc.GrpcService;
import alluxio.grpc.JournalDomain;
import alluxio.grpc.ServiceType;
import alluxio.master.FaultTolerantAlluxioJobMasterProcess;
import alluxio.master.Master;
import alluxio.master.MasterContext;
import alluxio.master.MasterProcess;
import alluxio.master.PrimarySelector;
import alluxio.master.job.JobMaster;
import alluxio.master.journal.DefaultJournalMaster;
import alluxio.master.journal.JournalMaster;
import alluxio.master.journal.JournalMasterClientServiceHandler;
import alluxio.master.journal.JournalSystem;
import alluxio.master.journal.JournalUtils;
import alluxio.master.journal.raft.RaftJournalSystem;
import alluxio.security.user.ServerUserState;
import alluxio.security.user.UserState;
import alluxio.underfs.JobUfsManager;
import alluxio.underfs.UfsManager;
import alluxio.util.CommonUtils;
import alluxio.util.URIUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.web.JobMasterWebServer;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.grpc.BindableService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AlluxioJobMasterProcess
extends MasterProcess {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioJobMasterProcess.class);
    private final FileSystem mFileSystem;
    private final FileSystemContext mFsContext;
    protected JobMaster mJobMaster;
    final InetSocketAddress mRpcConnectAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.JOB_MASTER_RPC, (AlluxioConfiguration)ServerConfiguration.global());
    private UfsManager mUfsManager;

    AlluxioJobMasterProcess(JournalSystem journalSystem) {
        super(journalSystem, NetworkAddressUtils.ServiceType.JOB_MASTER_RPC, NetworkAddressUtils.ServiceType.JOB_MASTER_WEB);
        if (!ServerConfiguration.isSet((PropertyKey)PropertyKey.JOB_MASTER_HOSTNAME)) {
            ServerConfiguration.set((PropertyKey)PropertyKey.JOB_MASTER_HOSTNAME, (Object)NetworkAddressUtils.getLocalHostName((int)((int)ServerConfiguration.getMs((PropertyKey)PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS))));
        }
        this.mFsContext = FileSystemContext.create((AlluxioConfiguration)ServerConfiguration.global());
        this.mFileSystem = FileSystem.Factory.create((FileSystemContext)this.mFsContext);
        this.mUfsManager = new JobUfsManager();
        try {
            if (!this.mJournalSystem.isFormatted()) {
                this.mJournalSystem.format();
            }
            this.mJobMaster = new JobMaster(new MasterContext(this.mJournalSystem, null, this.mUfsManager), this.mFileSystem, this.mFsContext, this.mUfsManager);
        }
        catch (Exception e) {
            LOG.error("Failed to create job master", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public <T extends Master> T getMaster(Class<T> clazz) {
        if (clazz == JobMaster.class) {
            return (T)((Object)this.mJobMaster);
        }
        throw new RuntimeException(String.format("Could not find the master: %s", clazz));
    }

    public JobMaster getJobMaster() {
        return this.mJobMaster;
    }

    @Nullable
    public InetSocketAddress getWebAddress() {
        if (this.mWebServer != null) {
            return new InetSocketAddress(this.mWebServer.getBindHost(), this.mWebServer.getLocalPort());
        }
        return null;
    }

    public InetSocketAddress getRpcAddress() {
        return this.mRpcConnectAddress;
    }

    public void start() throws Exception {
        this.mJournalSystem.start();
        this.mJournalSystem.gainPrimacy();
        this.startMaster(true);
        this.startServing();
    }

    public void stop() throws Exception {
        this.stopRejectingServers();
        if (this.isGrpcServing()) {
            this.stopServing();
        }
        this.mJournalSystem.stop();
        this.stopMaster();
    }

    protected void startMaster(boolean isLeader) {
        try {
            if (!isLeader) {
                this.startRejectingServers();
            }
            this.mJobMaster.start(isLeader);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void stopMaster() {
        try {
            this.mJobMaster.stop();
        }
        catch (IOException e) {
            LOG.error("Failed to stop job master", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void startServing(String startMessage, String stopMessage) {
        LOG.info("Alluxio job master web server version {} starting{}. webAddress={}", new Object[]{"2.7.3", startMessage, this.mWebBindAddress});
        this.startServingRPCServer();
        this.startServingWebServer();
        LOG.info("Alluxio job master version {} started{}. bindAddress={}, connectAddress={}, webAddress={}", new Object[]{"2.7.3", startMessage, this.mRpcBindAddress, this.mRpcConnectAddress, this.mWebBindAddress});
        this.mGrpcServer.awaitTermination();
        LOG.info("Alluxio job master ended {}", (Object)stopMessage);
    }

    protected void startServingWebServer() {
        this.stopRejectingWebServer();
        this.mWebServer = new JobMasterWebServer(NetworkAddressUtils.ServiceType.JOB_MASTER_WEB.getServiceName(), this.mWebBindAddress, this);
        this.mWebServer.start();
    }

    protected void startServingRPCServer() {
        this.stopRejectingRpcServer();
        LOG.info("Starting gRPC server on address:{}", (Object)this.mRpcBindAddress);
        this.mGrpcServer = this.createRPCServer();
        try {
            this.mGrpcServer.start();
            InetSocketAddress listeningAddress = InetSocketAddress.createUnresolved(this.mRpcBindAddress.getHostName(), this.mGrpcServer.getBindPort());
            LOG.info("gRPC server listening on: {}", (Object)listeningAddress);
        }
        catch (IOException e) {
            LOG.error("gRPC serving failed.", (Throwable)e);
            throw new RuntimeException("gRPC serving failed");
        }
    }

    private GrpcServer createRPCServer() {
        GrpcServerBuilder builder = GrpcServerBuilder.forAddress((GrpcServerAddress)GrpcServerAddress.create((String)this.mRpcConnectAddress.getHostName(), (SocketAddress)this.mRpcBindAddress), (AlluxioConfiguration)ServerConfiguration.global(), (UserState)ServerUserState.global()).flowControlWindow((int)ServerConfiguration.getBytes((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_FLOWCONTROL_WINDOW)).keepAliveTime(ServerConfiguration.getMs((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_KEEPALIVE_TIME_MS), TimeUnit.MILLISECONDS).keepAliveTimeout(ServerConfiguration.getMs((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_KEEPALIVE_TIMEOUT_MS), TimeUnit.MILLISECONDS).permitKeepAlive(ServerConfiguration.getMs((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_PERMIT_KEEPALIVE_TIME_MS), TimeUnit.MILLISECONDS).maxInboundMessageSize((int)ServerConfiguration.getBytes((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_MAX_INBOUND_MESSAGE_SIZE));
        this.registerServices(builder, this.mJobMaster.getServices());
        builder.addService(ServiceType.JOURNAL_MASTER_CLIENT_SERVICE, new GrpcService((BindableService)new JournalMasterClientServiceHandler((JournalMaster)new DefaultJournalMaster(JournalDomain.JOB_MASTER, this.mJournalSystem))));
        return builder.build();
    }

    protected void stopServing() throws Exception {
        if (this.isGrpcServing()) {
            LOG.info("Stopping Alluxio job master RPC server on {} @ {}", (Object)this, (Object)this.mRpcBindAddress);
            if (!this.mGrpcServer.shutdown()) {
                LOG.warn("Alluxio job master RPC server shutdown timed out.");
            }
        }
        if (this.mWebServer != null) {
            this.mWebServer.stop();
            this.mWebServer = null;
        }
    }

    public String toString() {
        return "Alluxio job master @ " + this.mRpcConnectAddress;
    }

    @ThreadSafe
    static final class Factory {
        public static AlluxioJobMasterProcess create() {
            URI journalLocation = JournalUtils.getJournalLocation();
            JournalSystem journalSystem = new JournalSystem.Builder().setLocation(URIUtils.appendPathOrDie((URI)journalLocation, (String)"JobJournal")).build(CommonUtils.ProcessType.JOB_MASTER);
            if (ServerConfiguration.getBoolean((PropertyKey)PropertyKey.ZOOKEEPER_ENABLED)) {
                Preconditions.checkState((!(journalSystem instanceof RaftJournalSystem) ? 1 : 0) != 0, (Object)"Raft journal cannot be used with Zookeeper enabled");
                PrimarySelector primarySelector = PrimarySelector.Factory.createZkJobPrimarySelector();
                return new FaultTolerantAlluxioJobMasterProcess(journalSystem, primarySelector);
            }
            if (journalSystem instanceof RaftJournalSystem) {
                PrimarySelector primarySelector = ((RaftJournalSystem)journalSystem).getPrimarySelector();
                return new FaultTolerantAlluxioJobMasterProcess(journalSystem, primarySelector);
            }
            return new AlluxioJobMasterProcess(journalSystem);
        }

        private Factory() {
        }
    }
}

