/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.workflow;

import alluxio.exception.ExceptionMessage;
import alluxio.exception.JobDoesNotExistException;
import alluxio.job.workflow.WorkflowConfig;
import alluxio.job.workflow.WorkflowExecution;
import alluxio.job.workflow.WorkflowExecutionFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WorkflowExecutionRegistry {
    INSTANCE;

    private static final Logger LOG;
    private final Map<Class<?>, WorkflowExecutionFactory<?>> mExecutionFactories = new HashMap();

    private void discoverWorkflowExecutionFactories() {
        ServiceLoader<WorkflowExecutionFactory> discoveredFactories = ServiceLoader.load(WorkflowExecutionFactory.class, WorkflowExecutionFactory.class.getClassLoader());
        for (WorkflowExecutionFactory executionFactory : discoveredFactories) {
            this.mExecutionFactories.put(executionFactory.getWorkflowConfigClass(), executionFactory);
            LOG.info("Loaded execution factory " + executionFactory.getClass().getSimpleName() + " for config " + executionFactory.getWorkflowConfigClass().getName());
        }
    }

    private WorkflowExecutionFactory getExecutionFactory(WorkflowConfig config) throws JobDoesNotExistException {
        if (!this.mExecutionFactories.containsKey(config.getClass())) {
            throw new JobDoesNotExistException(ExceptionMessage.JOB_DEFINITION_DOES_NOT_EXIST.getMessage(new Object[]{config.getName()}));
        }
        return this.mExecutionFactories.get(config.getClass());
    }

    public WorkflowExecution getExecution(WorkflowConfig config) throws JobDoesNotExistException {
        return this.getExecutionFactory(config).create(config);
    }

    static {
        LOG = LoggerFactory.getLogger(WorkflowExecutionRegistry.class);
        INSTANCE.discoverWorkflowExecutionFactories();
    }
}

