/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format.orc;

import alluxio.job.plan.transform.FieldSchema;
import alluxio.job.plan.transform.HiveConstants;
import alluxio.job.plan.transform.format.TableRow;
import alluxio.job.plan.transform.format.csv.Decimal;
import alluxio.job.plan.transform.format.orc.OrcSchema;
import alluxio.job.plan.transform.format.parquet.ParquetRow;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VoidColumnVector;

public class OrcRow
implements TableRow {
    private final VectorizedRowBatch mBatch;
    private final int mPosition;
    private final Map<String, Integer> mColumnNamePosition;
    private final OrcSchema mSchema;

    public OrcRow(OrcSchema schema, VectorizedRowBatch batch, int position, List<String> fieldNames) {
        this.mSchema = schema;
        this.mBatch = batch;
        this.mPosition = position;
        this.mColumnNamePosition = new HashMap<String, Integer>();
        for (int i = 0; i < fieldNames.size(); ++i) {
            String fieldName = fieldNames.get(i);
            this.mColumnNamePosition.put(fieldName, i);
        }
    }

    @Override
    public ParquetRow toParquet() throws IOException {
        Schema writeSchema = this.mSchema.getWriteSchema();
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(writeSchema);
        for (FieldSchema field : this.mSchema.getAlluxioSchema()) {
            String name = field.getName();
            String type = field.getType();
            Object value = this.getColumn(name);
            recordBuilder.set(writeSchema.getField(name), this.convert(value, name, type));
        }
        return new ParquetRow(recordBuilder.build());
    }

    @Override
    public Object getColumn(String column) {
        Integer columnPosition = this.mColumnNamePosition.get(column);
        if (columnPosition == null) {
            throw new IllegalArgumentException("Invalid column name: " + column);
        }
        ColumnVector col = this.mBatch.cols[columnPosition];
        if (col.isNull[this.mPosition]) {
            return null;
        }
        if (col instanceof TimestampColumnVector) {
            return ((TimestampColumnVector)col).asScratchTimestamp(this.mPosition).getTime();
        }
        if (col instanceof VoidColumnVector) {
            return null;
        }
        if (col instanceof DecimalColumnVector) {
            HiveDecimal hiveDecimal = ((DecimalColumnVector)col).vector[this.mPosition].getHiveDecimal();
            return hiveDecimal;
        }
        if (col instanceof LongColumnVector) {
            return ((LongColumnVector)col).vector[this.mPosition];
        }
        if (col instanceof BytesColumnVector) {
            BytesColumnVector bcv = (BytesColumnVector)col;
            return Arrays.copyOfRange(bcv.vector[this.mPosition], bcv.start[this.mPosition], bcv.start[this.mPosition] + bcv.length[this.mPosition]);
        }
        if (col instanceof DoubleColumnVector) {
            return ((DoubleColumnVector)col).vector[this.mPosition];
        }
        throw new UnsupportedOperationException("Unsupported column vector: " + col.getClass().getName());
    }

    private Object convert(Object value, String name, String type) throws IOException {
        if (value == null) {
            return null;
        }
        switch (HiveConstants.Types.getHiveConstantType((String)type)) {
            case "decimal": {
                Decimal decimal = new Decimal(type);
                return ((HiveDecimal)value).bigIntegerBytesScaled(decimal.getScale());
            }
            case "varchar": 
            case "char": 
            case "string": {
                return new String((byte[])value);
            }
        }
        return value;
    }
}

