/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format;

import alluxio.AlluxioURI;
import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.uri.NoAuthority;
import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;

public final class ReadWriterUtils {
    private static final String ALLUXIO_HADOOP_FILESYSTEM_DISABLE_CACHE = "fs.alluxio.impl.disable.cache";

    public static void checkUri(AlluxioURI uri) {
        Preconditions.checkArgument((uri.getScheme() != null && !uri.getScheme().isEmpty() ? 1 : 0) != 0, (Object)ExceptionMessage.TRANSFORM_TABLE_URI_LACKS_SCHEME.getMessage(new Object[]{uri}));
        if (uri.getScheme().equals("alluxio")) {
            Preconditions.checkArgument((uri.getAuthority() != null && !uri.getAuthority().equals(NoAuthority.INSTANCE) ? 1 : 0) != 0, (Object)ExceptionMessage.TRANSFORM_TABLE_URI_LACKS_AUTHORITY.getMessage(new Object[]{uri}));
        }
    }

    public static Configuration readNoCacheConf() {
        Configuration conf = new Configuration();
        conf.setEnum(PropertyKey.USER_FILE_READ_TYPE_DEFAULT.getName(), (Enum)ReadType.NO_CACHE);
        conf.setBoolean(ALLUXIO_HADOOP_FILESYSTEM_DISABLE_CACHE, true);
        return conf;
    }

    public static Configuration writeThroughConf() {
        Configuration conf = new Configuration();
        conf.setEnum(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT.getName(), (Enum)WriteType.THROUGH);
        conf.setBoolean(ALLUXIO_HADOOP_FILESYSTEM_DISABLE_CACHE, true);
        return conf;
    }

    private ReadWriterUtils() {
    }
}

