/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.replicate;

import alluxio.AlluxioURI;
import alluxio.client.block.AlluxioBlockStore;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.collections.Pair;
import alluxio.job.RunTaskContext;
import alluxio.job.SelectExecutorsContext;
import alluxio.job.plan.AbstractVoidPlanDefinition;
import alluxio.job.plan.replicate.ReplicateConfig;
import alluxio.job.util.JobUtils;
import alluxio.job.util.SerializableVoid;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.WorkerInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class ReplicateDefinition
extends AbstractVoidPlanDefinition<ReplicateConfig, SerializableVoid> {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicateDefinition.class);

    @Override
    public Class<ReplicateConfig> getJobConfigClass() {
        return ReplicateConfig.class;
    }

    @Override
    public Set<Pair<WorkerInfo, SerializableVoid>> selectExecutors(ReplicateConfig config, List<WorkerInfo> jobWorkerInfoList, SelectExecutorsContext context) throws Exception {
        Preconditions.checkArgument((!jobWorkerInfoList.isEmpty() ? 1 : 0) != 0, (Object)"No worker is available");
        long blockId = config.getBlockId();
        int numReplicas = config.getReplicas();
        Preconditions.checkArgument((numReplicas > 0 ? 1 : 0) != 0);
        AlluxioBlockStore blockStore = AlluxioBlockStore.create((FileSystemContext)context.getFsContext());
        BlockInfo blockInfo = blockStore.getInfo(blockId);
        HashSet<String> hosts = new HashSet<String>();
        for (BlockLocation blockLocation : blockInfo.getLocations()) {
            hosts.add(blockLocation.getWorkerAddress().getHost());
        }
        HashSet result = Sets.newHashSet();
        Collections.shuffle(jobWorkerInfoList);
        for (WorkerInfo workerInfo : jobWorkerInfoList) {
            if (hosts.contains(workerInfo.getAddress().getHost())) continue;
            result.add(new Pair((Object)workerInfo, null));
            if (result.size() < numReplicas) continue;
            break;
        }
        return result;
    }

    @Override
    public SerializableVoid runTask(ReplicateConfig config, SerializableVoid arg, RunTaskContext context) throws Exception {
        URIStatus status = context.getFileSystem().getStatus(new AlluxioURI(config.getPath()));
        JobUtils.loadBlock(status, context.getFsContext(), config.getBlockId(), null, false);
        LOG.info("Replicated file " + config.getPath() + " block " + config.getBlockId());
        return null;
    }
}

