/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.replicate;

import alluxio.client.block.AlluxioBlockStore;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.client.file.FileSystemContext;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.ServerConfiguration;
import alluxio.exception.status.NotFoundException;
import alluxio.grpc.RemoveBlockRequest;
import alluxio.job.RunTaskContext;
import alluxio.job.SelectExecutorsContext;
import alluxio.job.plan.AbstractVoidPlanDefinition;
import alluxio.job.plan.replicate.EvictConfig;
import alluxio.job.util.SerializableVoid;
import alluxio.resource.CloseableResource;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class EvictDefinition
extends AbstractVoidPlanDefinition<EvictConfig, SerializableVoid> {
    private static final Logger LOG = LoggerFactory.getLogger(EvictDefinition.class);

    @Override
    public Class<EvictConfig> getJobConfigClass() {
        return EvictConfig.class;
    }

    @Override
    public Set<Pair<WorkerInfo, SerializableVoid>> selectExecutors(EvictConfig config, List<WorkerInfo> jobWorkerInfoList, SelectExecutorsContext context) throws Exception {
        Preconditions.checkArgument((!jobWorkerInfoList.isEmpty() ? 1 : 0) != 0, (Object)"No worker is available");
        long blockId = config.getBlockId();
        int numReplicas = config.getReplicas();
        AlluxioBlockStore blockStore = AlluxioBlockStore.create((FileSystemContext)context.getFsContext());
        BlockInfo blockInfo = blockStore.getInfo(blockId);
        HashSet<String> hosts = new HashSet<String>();
        for (BlockLocation blockLocation : blockInfo.getLocations()) {
            hosts.add(blockLocation.getWorkerAddress().getHost());
        }
        HashSet result = Sets.newHashSet();
        Collections.shuffle(jobWorkerInfoList);
        for (WorkerInfo workerInfo : jobWorkerInfoList) {
            if (!hosts.contains(workerInfo.getAddress().getHost())) continue;
            result.add(new Pair((Object)workerInfo, null));
            if (result.size() < numReplicas) continue;
            break;
        }
        return result;
    }

    @Override
    public SerializableVoid runTask(EvictConfig config, SerializableVoid args, RunTaskContext context) throws Exception {
        long blockId = config.getBlockId();
        String localHostName = NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.WORKER_RPC, (AlluxioConfiguration)ServerConfiguration.global());
        List workerInfoList = context.getFsContext().getCachedWorkers();
        WorkerNetAddress localNetAddress = null;
        for (BlockWorkerInfo workerInfo : workerInfoList) {
            if (!workerInfo.getNetAddress().getHost().equals(localHostName)) continue;
            localNetAddress = workerInfo.getNetAddress();
            break;
        }
        if (localNetAddress == null) {
            String message = String.format("Cannot find a local block worker to evict block %d", blockId);
            throw new NotFoundException(message);
        }
        RemoveBlockRequest request = RemoveBlockRequest.newBuilder().setBlockId(blockId).build();
        try (CloseableResource blockWorker = context.getFsContext().acquireBlockWorkerClient(localNetAddress);){
            ((BlockWorkerClient)blockWorker.get()).removeBlock(request);
        }
        catch (NotFoundException e) {
            LOG.warn("Failed to delete block {} on {}: block does not exist", (Object)blockId, (Object)localNetAddress);
        }
        return null;
    }
}

