/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.wire;

import alluxio.grpc.JobServiceSummary;
import alluxio.job.ProtoUtils;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.job.wire.StatusSummary;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class JobServiceSummary {
    public static final int RECENT_LENGTH = 10;
    private final List<StatusSummary> mSummaryPerStatus;
    private final List<JobInfo> mRecentActivities;
    private final List<JobInfo> mRecentFailures;
    private final List<JobInfo> mLongestRunning;

    public JobServiceSummary(List<JobInfo> jobInfos) {
        jobInfos.sort(Comparator.comparing(JobInfo::getLastUpdated).reversed());
        this.mSummaryPerStatus = this.buildSummaryPerStatus(jobInfos);
        this.mRecentActivities = jobInfos.stream().limit(10L).collect(Collectors.toList());
        this.mRecentFailures = jobInfos.stream().filter(jobInfo -> jobInfo.getStatus().equals((Object)Status.FAILED)).limit(10L).collect(Collectors.toList());
        Collections.reverse(jobInfos);
        this.mLongestRunning = jobInfos.stream().filter(jobInfo -> jobInfo.getStatus().equals((Object)Status.RUNNING)).limit(10L).collect(Collectors.toList());
    }

    public JobServiceSummary(alluxio.grpc.JobServiceSummary jobServiceSummary) throws IOException {
        this.mSummaryPerStatus = new ArrayList<StatusSummary>();
        for (alluxio.grpc.StatusSummary statusSummary : jobServiceSummary.getSummaryPerStatusList()) {
            this.mSummaryPerStatus.add(new StatusSummary(statusSummary));
        }
        this.mRecentActivities = new ArrayList<JobInfo>();
        for (alluxio.grpc.JobInfo lastActivity : jobServiceSummary.getRecentActivitiesList()) {
            this.mRecentActivities.add(ProtoUtils.fromProto(lastActivity));
        }
        this.mRecentFailures = new ArrayList<JobInfo>();
        for (alluxio.grpc.JobInfo lastFailure : jobServiceSummary.getRecentFailuresList()) {
            this.mRecentFailures.add(ProtoUtils.fromProto(lastFailure));
        }
        this.mLongestRunning = new ArrayList<JobInfo>();
        for (alluxio.grpc.JobInfo longestRunning : jobServiceSummary.getLongestRunningList()) {
            this.mLongestRunning.add(ProtoUtils.fromProto(longestRunning));
        }
    }

    private List<StatusSummary> buildSummaryPerStatus(List<JobInfo> jobInfos) {
        HashMap<Status, Long> countPerStatus = new HashMap<Status, Long>();
        for (JobInfo jobInfo : jobInfos) {
            Status status = Status.valueOf(jobInfo.getStatus().name());
            countPerStatus.compute(status, (key, val) -> val == null ? 1L : val + 1L);
        }
        ArrayList<StatusSummary> result = new ArrayList<StatusSummary>();
        for (Status status : Status.values()) {
            Long count = (Long)countPerStatus.get((Object)status);
            if (count == null) {
                count = 0L;
            }
            result.add(new StatusSummary(status, count));
        }
        return result;
    }

    public Collection<StatusSummary> getSummaryPerStatus() {
        return Collections.unmodifiableCollection(this.mSummaryPerStatus);
    }

    public List<JobInfo> getRecentActivities() {
        return Collections.unmodifiableList(this.mRecentActivities);
    }

    public List<JobInfo> getRecentFailures() {
        return Collections.unmodifiableList(this.mRecentFailures);
    }

    public List<JobInfo> getLongestRunning() {
        return Collections.unmodifiableList(this.mLongestRunning);
    }

    public alluxio.grpc.JobServiceSummary toProto() throws IOException {
        JobServiceSummary.Builder jobServiceBuilder = alluxio.grpc.JobServiceSummary.newBuilder();
        for (StatusSummary statusSummary : this.mSummaryPerStatus) {
            jobServiceBuilder.addSummaryPerStatus(statusSummary.toProto());
        }
        for (JobInfo jobInfo : this.mRecentActivities) {
            jobServiceBuilder.addRecentActivities(jobInfo.toProto());
        }
        for (JobInfo jobInfo : this.mRecentFailures) {
            jobServiceBuilder.addRecentFailures(jobInfo.toProto());
        }
        for (JobInfo jobInfo : this.mLongestRunning) {
            jobServiceBuilder.addLongestRunning(jobInfo.toProto());
        }
        return jobServiceBuilder.build();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobServiceSummary)) {
            return false;
        }
        JobServiceSummary that = (JobServiceSummary)o;
        return Objects.equal(this.mSummaryPerStatus, that.mSummaryPerStatus) && Objects.equal(this.mRecentActivities, that.mRecentActivities) && Objects.equal(this.mRecentFailures, that.mRecentFailures) && Objects.equal(this.mLongestRunning, that.mLongestRunning);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mSummaryPerStatus});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("summaryPerStatus", this.mSummaryPerStatus).add("recentActivities", this.mRecentActivities).add("recentFailures", this.mRecentFailures).add("oldRunning", this.mLongestRunning).toString();
    }
}

