/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.cmd.load;

import alluxio.grpc.OperationType;
import alluxio.job.cmd.CliConfig;
import alluxio.job.wire.JobSource;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LoadCliConfig
implements CliConfig {
    public static final String NAME = "LoadCli";
    private static final long serialVersionUID = -5268683490243619278L;
    private final String mFilePath;
    private final int mReplication;
    private final Set<String> mWorkerSet;
    private final Set<String> mExcludedWorkerSet;
    private final Set<String> mLocalityIds;
    private final Set<String> mExcludedLocalityIds;
    private final int mBatchSize;
    private final boolean mDirectCache;

    public LoadCliConfig(@JsonProperty(value="filePath") String filePath, @JsonProperty(value="batchSize") Integer batchSize, @JsonProperty(value="replication") Integer replication, @JsonProperty(value="workerSet") Set<String> workerSet, @JsonProperty(value="excludedWorkerSet") Set<String> excludedWorkerSet, @JsonProperty(value="localityIds") Set<String> localityIds, @JsonProperty(value="excludedLocalityIds") Set<String> excludedLocalityIds, @JsonProperty(value="directCache") boolean directCache) {
        this.mFilePath = (String)Preconditions.checkNotNull((Object)filePath, (Object)"The file path cannot be null");
        this.mBatchSize = batchSize;
        this.mReplication = replication == null ? 1 : replication;
        this.mWorkerSet = workerSet == null ? Collections.EMPTY_SET : new HashSet<String>(workerSet);
        this.mExcludedWorkerSet = excludedWorkerSet == null ? Collections.EMPTY_SET : new HashSet<String>(excludedWorkerSet);
        this.mLocalityIds = localityIds == null ? Collections.EMPTY_SET : new HashSet<String>(localityIds);
        this.mExcludedLocalityIds = excludedLocalityIds == null ? Collections.EMPTY_SET : new HashSet<String>(excludedLocalityIds);
        this.mDirectCache = directCache;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public JobSource getJobSource() {
        return JobSource.CLI;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.DIST_LOAD;
    }

    @Override
    public Collection<String> affectedPaths() {
        return ImmutableList.of((Object)this.mFilePath);
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public int getReplication() {
        return this.mReplication;
    }

    public Set<String> getWorkerSet() {
        return this.mWorkerSet;
    }

    public Set<String> getExcludedWorkerSet() {
        return this.mExcludedWorkerSet;
    }

    public Set<String> getLocalityIds() {
        return this.mLocalityIds;
    }

    public Set<String> getExcludedLocalityIds() {
        return this.mExcludedLocalityIds;
    }

    public int getBatchSize() {
        return this.mBatchSize;
    }

    public boolean getDirectCache() {
        return this.mDirectCache;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LoadCliConfig)) {
            return false;
        }
        LoadCliConfig that = (LoadCliConfig)obj;
        return this.mFilePath.equals(that.mFilePath) && this.mReplication == that.mReplication;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mFilePath, this.mReplication});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("FilePath", (Object)this.mFilePath).add("Replication", this.mReplication).toString();
    }
}

