/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.hdfs;

import alluxio.cli.ApplicableUfsType;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.cli.hdfs.HdfsConfValidationTask;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.util.ExceptionUtils;
import alluxio.util.ShellUtils;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@ApplicableUfsType(value=ApplicableUfsType.Type.HDFS)
public final class SecureHdfsValidationTask
extends HdfsConfValidationTask {
    private static final Pattern PRINCIPAL_PATTERN = Pattern.compile("(?<primary>[^/@]*)(/(?<instance>[^/@]*))?@(?<realm>[^/@]*)");
    private static final String PRINCIPAL_MAP_MASTER_KEY = "master";
    private static final String PRINCIPAL_MAP_WORKER_KEY = "worker";
    private static final Map<String, PropertyKey> PRINCIPAL_MAP = ImmutableMap.of((Object)"master", (Object)PropertyKey.MASTER_PRINCIPAL, (Object)"worker", (Object)PropertyKey.WORKER_PRINCIPAL);
    private static final Map<String, PropertyKey> KEYTAB_MAP = ImmutableMap.of((Object)"master", (Object)PropertyKey.MASTER_KEYTAB_KEY_FILE, (Object)"worker", (Object)PropertyKey.WORKER_KEYTAB_FILE);
    private static final String HDFS_AUTHENTICATION_KEY = "hadoop.security.authentication";
    private static final String HDFS_AUTHENTICATION_VALUE = "kerberos";
    private static final String DOC_LINK = "https://docs.alluxio.io/os/user/stable/en/ufs/HDFS.html#connect-to-secure-hdfs";
    private final String mProcess;
    private PropertyKey mPrincipalProperty;
    private PropertyKey mKeytabProperty;
    private final AlluxioConfiguration mConf;
    private final StringBuilder mMsg;
    private final StringBuilder mAdvice;
    private final String mPath;

    public SecureHdfsValidationTask(String process, String path, AlluxioConfiguration conf) {
        super(path, conf);
        this.mConf = conf;
        this.mPath = path;
        this.mProcess = process.toLowerCase();
        this.mPrincipalProperty = PRINCIPAL_MAP.get(this.mProcess);
        this.mKeytabProperty = KEYTAB_MAP.get(this.mProcess);
        this.mMsg = new StringBuilder();
        this.mAdvice = new StringBuilder();
    }

    @Override
    public String getName() {
        return String.format("ValidateKerberosForSecureHdfs%s", StringUtils.capitalize((String)this.mProcess));
    }

    @Override
    public ValidationTaskResult validateImpl(Map<String, String> optionsMap) {
        if (!ValidationUtils.isHdfsScheme((String)this.mPath)) {
            this.mMsg.append("Skip this check as the UFS is not HDFS.\n");
            return new ValidationTaskResult(ValidationUtils.State.SKIPPED, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
        }
        ValidationTaskResult loadConfig = this.loadHdfsConfig();
        if (loadConfig.getState() != ValidationUtils.State.OK) {
            String extraAdvice = "Validating a secure HDFS connection requires specifying additional HDFS configuration files. ";
            return loadConfig.setAdvice(extraAdvice + loadConfig.getAdvice());
        }
        ValidationTaskResult hdfsSecured = this.validateSecureHdfs();
        if (hdfsSecured.getState() != ValidationUtils.State.OK) {
            return hdfsSecured;
        }
        return this.validatePrincipalLogin();
    }

    private ValidationTaskResult validateSecureHdfs() {
        String hadoopAuthentication = this.mCoreConf.getOrDefault(HDFS_AUTHENTICATION_KEY, "");
        boolean authenticationEnabled = hadoopAuthentication.equalsIgnoreCase(HDFS_AUTHENTICATION_VALUE);
        if (!authenticationEnabled) {
            this.mMsg.append("HDFS is not Kerberized. Skip this test.");
            return new ValidationTaskResult(ValidationUtils.State.SKIPPED, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
        }
        return new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
    }

    private ValidationTaskResult validatePrincipalLogin() {
        String principal = (String)this.mConf.getOrDefault(this.mPrincipalProperty, (Object)"");
        String keytab = (String)this.mConf.getOrDefault(this.mKeytabProperty, (Object)"");
        if (principal.isEmpty() || keytab.isEmpty()) {
            this.mMsg.append(String.format("Failed to find Kerberos principal and keytab. Found %s=%s and %s=%s.%n", this.mPrincipalProperty.toString(), principal, this.mKeytabProperty, keytab));
            this.mAdvice.append(String.format("Please configure Alluxio to connect with secure HDFS following %s%n", DOC_LINK));
            return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
        }
        Matcher matchPrincipal = PRINCIPAL_PATTERN.matcher(principal);
        if (!matchPrincipal.matches()) {
            this.mMsg.append(String.format("Principal %s is not in the right format.%n", principal));
            this.mAdvice.append(String.format("Please fix principal %s=%s.%n", this.mPrincipalProperty.toString(), principal));
            return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
        }
        String primary = matchPrincipal.group("primary");
        String instance = matchPrincipal.group("instance");
        String realm = matchPrincipal.group("realm");
        Object[] command = new String[]{"kinit", "-kt", keytab, principal};
        try {
            String output = ShellUtils.execCommand((String[])command);
            this.mMsg.append(String.format("Command %s finished with output: %s%n", Arrays.toString(command), output));
            return new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
        }
        catch (IOException e) {
            this.mMsg.append(String.format("Kerberos login failed for %s with keytab %s.%n", principal, keytab));
            this.mMsg.append(ExceptionUtils.asPlainText((Throwable)e));
            this.mMsg.append(String.format("Primary is %s, instance is %s and realm is %s.%n", primary, instance, realm));
            ValidationTaskResult result = new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
            return result;
        }
    }
}

