/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.hdfs;

import alluxio.cli.AbstractValidationTask;
import alluxio.cli.ApplicableUfsType;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.util.ExceptionUtils;
import alluxio.util.ShellUtils;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ApplicableUfsType(value=ApplicableUfsType.Type.HDFS)
public class HdfsVersionValidationTask
extends AbstractValidationTask {
    private final AlluxioConfiguration mConf;
    public static final String HADOOP_PREFIX = "hadoop-";
    public static final String CDH_PREFIX = "cdh-";
    private static final Pattern HADOOP_PATTERN = Pattern.compile("Hadoop\\s+(?<version>([0-9]\\.)+[0-9]+)");
    private static final Pattern CDH_PATTERN = Pattern.compile("cdh(?<cdhVersion>([0-9]+\\.)+[0-9]+)");

    public HdfsVersionValidationTask(AlluxioConfiguration conf) {
        this.mConf = conf;
    }

    public String getName() {
        return "ValidateHdfsVersion";
    }

    protected String parseVersion(String output) {
        Matcher cdhMatcher = CDH_PATTERN.matcher(output);
        if (cdhMatcher.find()) {
            String cdhVersion = cdhMatcher.group("cdhVersion");
            return "cdh" + cdhVersion;
        }
        String version = "";
        Matcher matcher = HADOOP_PATTERN.matcher(output);
        if (matcher.find()) {
            version = matcher.group("version");
        }
        return version;
    }

    public ValidationTaskResult validateImpl(Map<String, String> optionMap) throws InterruptedException {
        String hadoopVersion;
        try {
            hadoopVersion = this.getHadoopVersion();
        }
        catch (IOException e) {
            return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), String.format("Failed to get hadoop version:%n%s.", ExceptionUtils.asPlainText((Throwable)e)), "Please check if hadoop is on your PATH.");
        }
        String version = this.mConf.getString(PropertyKey.UNDERFS_VERSION);
        for (String prefix : new String[]{CDH_PREFIX, HADOOP_PREFIX}) {
            if (!version.startsWith(prefix)) continue;
            version = version.substring(prefix.length());
            break;
        }
        if (hadoopVersion.contains(version)) {
            return new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), String.format("Hadoop version %s contains UFS version defined in alluxio %s=%s.", hadoopVersion, PropertyKey.UNDERFS_VERSION, version), "");
        }
        return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), String.format("Hadoop version %s does not match %s=%s.", hadoopVersion, PropertyKey.UNDERFS_VERSION, version), String.format("Please configure %s to match the HDFS version.", PropertyKey.UNDERFS_VERSION));
    }

    protected String getHadoopVersion() throws IOException {
        String[] cmd = new String[]{"hadoop", "version"};
        String version = ShellUtils.execCommand((String[])cmd);
        return this.parseVersion(version);
    }
}

