/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.hdfs;

import alluxio.cli.ApplicableUfsType;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.cli.hdfs.HdfsConfValidationTask;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.security.authentication.AuthType;
import alluxio.security.user.UserState;
import alluxio.util.ExceptionUtils;
import java.util.Map;

@ApplicableUfsType(value=ApplicableUfsType.Type.HDFS)
public class HdfsProxyUserValidationTask
extends HdfsConfValidationTask {
    public HdfsProxyUserValidationTask(String path, AlluxioConfiguration conf) {
        super(path, conf);
    }

    @Override
    public String getName() {
        return "ValidateProxyUserConf";
    }

    private String getCurrentUser() throws UnauthenticatedException {
        UserState s = UserState.Factory.create((AlluxioConfiguration)this.mConf);
        return s.getUser().getName();
    }

    private ValidationTaskResult validateProxyUsers(String userName) {
        String proxyUserKey = String.format("hadoop.proxyuser.%s.users", userName);
        String proxyGroupKey = String.format("hadoop.proxyuser.%s.groups", userName);
        String proxyUsers = this.mCoreConf.getOrDefault(proxyUserKey, "");
        String proxyGroups = this.mCoreConf.getOrDefault(proxyGroupKey, "");
        if (proxyUsers.equals("") && proxyGroups.equals("")) {
            this.mMsg.append(String.format("Alluxio is running as user %s. But neither %s or %s is configured in hadoop configuration. Alluxio is not able to perform impersonation.%n", userName, proxyUserKey, proxyGroupKey));
            this.mAdvice.append(String.format("Please enable Alluxio user %s to impersonate.%n", userName));
            return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
        }
        if (proxyUsers.equals("*") || proxyGroups.equals("*")) {
            this.mMsg.append(String.format("Alluxio user %s can impersonate as any user/group in HDFS.%n", userName));
            return new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
        }
        this.mMsg.append(String.format("Alluxio user %s has %s=%s and %s=%s set for HDFS.%n", userName, proxyUserKey, proxyUsers, proxyGroupKey, proxyGroups));
        this.mAdvice.append(String.format("Please make sure that includes all users/groups Alluxio needs to impersonate as.%n", new Object[0]));
        return new ValidationTaskResult(ValidationUtils.State.WARNING, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
    }

    @Override
    public ValidationTaskResult validateImpl(Map<String, String> optionMap) {
        if (this.mConf.get(PropertyKey.SECURITY_AUTHENTICATION_TYPE).equals(AuthType.NOSASL)) {
            return new ValidationTaskResult(ValidationUtils.State.SKIPPED, this.getName(), String.format("Impersonation validation is skipped for NOSASL", new Object[0]), "");
        }
        ValidationTaskResult loadConfig = this.loadHdfsConfig();
        if (loadConfig.getState() != ValidationUtils.State.OK) {
            this.mAdvice.insert(0, "Validating the proxy user requires additional HDFS configuration. ");
            return loadConfig.setAdvice(this.mAdvice.toString());
        }
        try {
            String alluxioUser = this.getCurrentUser();
            return this.validateProxyUsers(alluxioUser);
        }
        catch (UnauthenticatedException e) {
            this.mMsg.append(String.format("Failed to authenticate in Alluxio: ", new Object[0]));
            this.mMsg.append(ExceptionUtils.asPlainText((Throwable)e));
            this.mAdvice.append("Please fix the authentication issue.");
            return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
        }
    }
}

