/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.AbstractValidationTask;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.util.ExceptionUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;

public final class UserLimitValidationTask
extends AbstractValidationTask {
    private static final int NUMBER_OF_OPEN_FILES_MIN = 16384;
    private static final int NUMBER_OF_OPEN_FILES_MAX = 800000;
    private static final int NUMBER_OF_USER_PROCESSES_MIN = 16384;
    private final String mCommand;
    private final Integer mLowerBound;
    private final Integer mUpperBound;

    private UserLimitValidationTask(String command, Integer lowerBound, Integer upperBound) {
        this.mCommand = command;
        this.mLowerBound = lowerBound;
        this.mUpperBound = upperBound;
    }

    public String getName() {
        return "ValidateUserLimit";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ValidationTaskResult validateImpl(Map<String, String> optionsMap) {
        ValidationUtils.State state = ValidationUtils.State.OK;
        StringBuilder msg = new StringBuilder();
        StringBuilder advice = new StringBuilder();
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", this.mCommand});
            try (BufferedReader processOutputReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = processOutputReader.readLine();
                if (line == null) {
                    msg.append(String.format("Unable to check user limit for %s.%n", this.getName()));
                    advice.append(String.format("Please check if you are able to run %s. ", this.mCommand));
                    ValidationTaskResult validationTaskResult = new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
                    return validationTaskResult;
                }
                if (line.equals("unlimited")) {
                    msg.append(String.format("The user limit for %s is unlimited. ", this.getName()));
                    if (this.mUpperBound != null) {
                        state = ValidationUtils.State.WARNING;
                        advice.append(String.format("The user limit should be less than %d. ", this.mUpperBound));
                    }
                    ValidationTaskResult validationTaskResult = new ValidationTaskResult(state, this.getName(), msg.toString(), advice.toString());
                    return validationTaskResult;
                }
                int value = Integer.parseInt(line);
                if (this.mUpperBound != null && value > this.mUpperBound) {
                    state = ValidationUtils.State.WARNING;
                    msg.append(String.format("The user limit for %s is too large. The current value is %d. ", this.getName(), value));
                    advice.append(String.format("The user limit should be less than %d. ", this.mUpperBound));
                }
                if (this.mLowerBound != null && value < this.mLowerBound) {
                    state = ValidationUtils.State.WARNING;
                    msg.append(String.format("The user limit for %s is too small. The current value is %d. ", this.getName(), value));
                    advice.append(String.format("For production use, it should be bigger than %d%n", this.mLowerBound));
                }
                ValidationTaskResult validationTaskResult = new ValidationTaskResult(state, this.getName(), msg.toString(), advice.toString());
                return validationTaskResult;
            }
        }
        catch (IOException e) {
            msg.append(String.format("Unable to check user limit for %s: %s. ", this.getName(), e.getMessage()));
            msg.append(ExceptionUtils.asPlainText((Throwable)e));
            return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
        }
    }

    public static AbstractValidationTask createOpenFilesLimitValidationTask() {
        return new UserLimitValidationTask("ulimit -n", 16384, 800000);
    }

    public static AbstractValidationTask createUserProcessesLimitValidationTask() {
        return new UserLimitValidationTask("ulimit -u", 16384, null);
    }
}

