/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.AbstractValidationTask;
import alluxio.cli.ApplicableUfsType;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactoryRegistry;
import java.util.List;
import java.util.Map;

@ApplicableUfsType(value=ApplicableUfsType.Type.ALL)
public class UfsVersionValidationTask
extends AbstractValidationTask {
    private final String mUfsPath;
    private final AlluxioConfiguration mConf;

    public UfsVersionValidationTask(String ufsPath, AlluxioConfiguration ufsConf) {
        this.mUfsPath = ufsPath;
        this.mConf = ufsConf;
    }

    protected ValidationTaskResult validateImpl(Map<String, String> optionMap) {
        UnderFileSystemConfiguration ufsConf = UnderFileSystemConfiguration.defaults((AlluxioConfiguration)this.mConf).createMountSpecificConf(optionMap);
        String configuredVersion = this.mConf.getString(PropertyKey.UNDERFS_VERSION);
        List availableVersions = UnderFileSystemFactoryRegistry.getSupportedVersions((String)this.mUfsPath, (AlluxioConfiguration)ufsConf);
        ValidationTaskResult result = new ValidationTaskResult();
        result.setName(this.getName());
        result.setDesc("Validates that the configured UFS version exists as a library on the system.");
        if (!this.mConf.isSetByUser(PropertyKey.UNDERFS_VERSION)) {
            result.setState(ValidationUtils.State.SKIPPED);
            result.setOutput("The UFS version was not configured by the user.");
        } else if (availableVersions.contains(configuredVersion)) {
            result.setState(ValidationUtils.State.OK);
            result.setOutput(String.format("The UFS path %s with configured version %s is supported by the current installation", this.mUfsPath, configuredVersion));
        } else {
            result.setState(ValidationUtils.State.FAILED);
            if (availableVersions.size() > 0) {
                result.setOutput(String.format("UFS path %s was configured with version %s. The supported versions on this system are: %s", this.mUfsPath, configuredVersion, availableVersions.toString()));
            } else {
                result.setOutput(String.format("UFS path %s was configured with version %s. This path does not support UFS version configuration.", this.mUfsPath, configuredVersion));
            }
            result.setAdvice(String.format("Configured UFS version %s not available. Check that the version is correct. Otherwise, consider using a different version.", configuredVersion));
        }
        return result;
    }

    public String getName() {
        return "UfsVersionValidationTask";
    }
}

