/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.AbstractValidationTask;
import alluxio.cli.ApplicableUfsType;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.ExceptionUtils;
import java.util.Map;

@ApplicableUfsType(value=ApplicableUfsType.Type.ALL)
public final class UfsDirectoryValidationTask
extends AbstractValidationTask {
    private final String mPath;
    private final AlluxioConfiguration mConf;

    public UfsDirectoryValidationTask(String path, AlluxioConfiguration conf) {
        this.mPath = path;
        this.mConf = conf;
    }

    public String getName() {
        return "ValidateUfsDir";
    }

    public ValidationTaskResult validateImpl(Map<String, String> optionsMap) {
        StringBuilder msg = new StringBuilder();
        StringBuilder advice = new StringBuilder();
        try {
            UnderFileSystem ufs = UnderFileSystem.Factory.create((String)this.mPath, (AlluxioConfiguration)this.mConf);
            UfsStatus[] listStatus = ufs.listStatus(this.mPath);
            if (listStatus == null) {
                msg.append(String.format("Unable to list under file system path %s. ", this.mPath));
                advice.append(String.format("Please check if path %s denotes a directory. ", this.mPath));
                return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
            }
            msg.append(String.format("Successfully listed path %s. ", this.mPath));
            return new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), msg.toString(), advice.toString());
        }
        catch (Exception e) {
            msg.append(String.format("Unable to access under file system path %s: %s. ", this.mPath, e.getMessage()));
            msg.append(ExceptionUtils.asPlainText((Throwable)e));
            advice.append(String.format("Please verify your path %s is correct.%n", this.mPath));
            return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
        }
    }
}

