/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.AbstractValidationTask;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.util.ExceptionUtils;
import alluxio.util.FormatUtils;
import alluxio.util.ShellUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public final class StorageSpaceValidationTask
extends AbstractValidationTask {
    private final AlluxioConfiguration mConf;

    public StorageSpaceValidationTask(AlluxioConfiguration conf) {
        this.mConf = conf;
    }

    public String getName() {
        return "ValidateStorageSpace";
    }

    public ValidationTaskResult validateImpl(Map<String, String> optionsMap) {
        StringBuilder msg = new StringBuilder();
        StringBuilder advice = new StringBuilder();
        int numLevel = this.mConf.getInt(PropertyKey.WORKER_TIERED_STORE_LEVELS);
        boolean success = true;
        for (int level = 0; level < numLevel; ++level) {
            PropertyKey tierAliasConf = PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(new Object[]{level});
            String alias = this.mConf.getString(tierAliasConf);
            PropertyKey tierDirPathConf = PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{level});
            String[] dirPaths = this.mConf.getString(tierDirPathConf).split(",");
            PropertyKey tierDirCapacityConf = PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA.format(new Object[]{level});
            List dirQuotas = this.mConf.getList(tierDirCapacityConf);
            if (dirQuotas.isEmpty()) {
                msg.append(String.format("Tier %d: Quota cannot be empty.%n", level));
                advice.append(String.format("Please check your setting for %s.%n", tierDirCapacityConf));
                return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
            }
            try {
                HashMap<String, MountedStorage> storageMap = new HashMap<String, MountedStorage>();
                File file = new File(dirPaths[0]);
                if (dirPaths.length == 1 && alias.equals("MEM") && !file.exists()) {
                    msg.append(String.format("RAM disk is not mounted at %s, skip validation.%n", dirPaths[0]));
                    continue;
                }
                boolean hasRamfsLocation = false;
                for (int i = 0; i < dirPaths.length; ++i) {
                    int index;
                    int n = index = i >= dirQuotas.size() ? dirQuotas.size() - 1 : i;
                    if (ShellUtils.isMountingPoint((String)dirPaths[i], (String[])new String[]{"ramfs"})) {
                        msg.append(String.format("ramfs mounted at %s does not report space information, skip validation.%n", dirPaths[i]));
                        hasRamfsLocation = true;
                        break;
                    }
                    long quota = FormatUtils.parseSpaceSize((String)((String)dirQuotas.get(index)));
                    success &= this.addDirectoryInfo(dirPaths[i], quota, storageMap);
                }
                if (hasRamfsLocation) continue;
                for (Map.Entry storageEntry : storageMap.entrySet()) {
                    MountedStorage storage = (MountedStorage)storageEntry.getValue();
                    long quota = storage.getDesiredQuotaSizeBytes();
                    long used = storage.getUsedTieredStorageSizeBytes();
                    long available = storage.getAvailableSizeBytes();
                    StringBuilder builder = new StringBuilder();
                    for (Map.Entry<String, Long> directoryQuota : storage.getDirectoryQuotas().entrySet()) {
                        builder.append(String.format("- Quota for %s: %s%n", directoryQuota.getKey(), FormatUtils.getSizeFromBytes((long)directoryQuota.getValue())));
                    }
                    if (quota <= used + available) continue;
                    msg.append(String.format("Tier %d: Not enough space on %s. %nTotal desired quota: %s%n%sUsed in tiered storage: %s%nAvailable: %s (Additional %s free space required).%n", level, storageEntry.getKey(), FormatUtils.getSizeFromBytes((long)quota), builder, FormatUtils.getSizeFromBytes((long)used), FormatUtils.getSizeFromBytes((long)available), FormatUtils.getSizeFromBytes((long)(quota - used - available))));
                    advice.append(String.format("Please check your quota setting for tier %s.%n", level));
                    success = false;
                }
                continue;
            }
            catch (IOException e) {
                msg.append(String.format("Tier %d: Unable to validate available space - %s.%n", level, e.getMessage()));
                msg.append(ExceptionUtils.asPlainText((Throwable)e));
                advice.append(String.format("Please check your path for tier %s.%n", level));
                success = false;
            }
        }
        ValidationUtils.State state = success ? ValidationUtils.State.OK : ValidationUtils.State.WARNING;
        return new ValidationTaskResult(state, this.getName(), msg.toString(), advice.toString());
    }

    private boolean addDirectoryInfo(String path, long quota, Map<String, MountedStorage> storageMap) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            System.err.format("Path %s does not exist.%n", path);
            return false;
        }
        if (!file.isDirectory()) {
            System.err.format("Path %s is not a valid directory.%n", path);
            return false;
        }
        long directorySize = FileUtils.sizeOfDirectory((File)file);
        FileStore store = Files.getFileStore(Paths.get(path, new String[0]));
        MountedStorage storage = storageMap.get(store.name());
        if (storage == null) {
            storage = new MountedStorage(store);
            storageMap.put(store.name(), storage);
        }
        storage.addDirectoryInfo(path, quota, directorySize);
        return true;
    }

    private final class MountedStorage {
        private long mDesiredQuotaSizeBytes = 0L;
        private long mUsedTieredStorageSizeBytes = 0L;
        private FileStore mFileStore;
        private final Map<String, Long> mDirectoryQuotas;

        public MountedStorage(FileStore store) {
            this.mFileStore = store;
            this.mDirectoryQuotas = new HashMap<String, Long>();
        }

        public long getDesiredQuotaSizeBytes() {
            return this.mDesiredQuotaSizeBytes;
        }

        public long getUsedTieredStorageSizeBytes() {
            return this.mUsedTieredStorageSizeBytes;
        }

        public long getAvailableSizeBytes() throws IOException {
            return this.mFileStore.getUsableSpace();
        }

        public Map<String, Long> getDirectoryQuotas() {
            return this.mDirectoryQuotas;
        }

        public void addDirectoryInfo(String path, long quota, long directorySize) {
            this.mDirectoryQuotas.put(path, quota);
            this.mUsedTieredStorageSizeBytes += directorySize;
            this.mDesiredQuotaSizeBytes += quota;
        }
    }
}

