/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.AbstractValidationTask;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import java.util.Map;
import java.util.Set;

public final class SshValidationTask
extends AbstractValidationTask {
    private final AlluxioConfiguration mConf;

    public SshValidationTask(AlluxioConfiguration conf) {
        this.mConf = conf;
    }

    public String getName() {
        return "ValidateSshAccessibility";
    }

    public ValidationTaskResult validateImpl(Map<String, String> optionsMap) {
        StringBuilder msg = new StringBuilder();
        StringBuilder advice = new StringBuilder();
        Set nodes = ConfigurationUtils.getServerHostnames((AlluxioConfiguration)this.mConf);
        if (nodes == null) {
            msg.append("Failed to find master/worker nodes from Alluxio configuration. ");
            advice.append(String.format("Please check your %s/master and %s/worker files. ", this.mConf.getString(PropertyKey.CONF_DIR)));
            return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
        }
        ValidationUtils.State state = ValidationUtils.State.OK;
        for (String nodeName : nodes) {
            if (CommonUtils.isAddressReachable((String)nodeName, (int)22, (int)30000)) continue;
            msg.append(String.format("Unable to reach ssh port 22 on node %s.%n", nodeName));
            advice.append(String.format("Please configure password-less ssh to node %s.%n", nodeName));
            state = ValidationUtils.State.FAILED;
        }
        return new ValidationTaskResult(state, this.getName(), msg.toString(), advice.toString());
    }
}

