/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.RelatedS3Operations;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.CreateOptions;
import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public final class S3ASpecificOperations {
    private static final long TEST_WAIT_TIME = 10000L;
    private static final byte[] TEST_BYTES = "TestBytesInS3AFiles".getBytes();
    private final InstancedConfiguration mConfiguration;
    private final String mTestDirectory;
    private final UnderFileSystem mUfs;

    public S3ASpecificOperations(String testDirectory, UnderFileSystem ufs, InstancedConfiguration configuration) {
        this.mTestDirectory = testDirectory;
        this.mUfs = ufs;
        this.mConfiguration = configuration;
    }

    public void createEmptyFileTest() throws IOException {
        String testFile = PathUtils.concatPath((Object)this.mTestDirectory, (Object)"createEmpty");
        OutputStream o = this.mUfs.create(testFile);
        o.close();
        byte[] buf = new byte[]{};
        int bytesRead = this.mUfs.open(testFile).read(buf);
        if (bytesRead != 0) {
            throw new IOException("The written file should be empty but is not");
        }
    }

    @RelatedS3Operations(operations={"initiateMultipartUpload", "uploadPart", "completeMultipartUpload"})
    public void createFileLessThanOnePartTest() throws IOException {
        String testFile = PathUtils.concatPath((Object)this.mTestDirectory, (Object)"createOnePart");
        OutputStream o = this.mUfs.create(testFile);
        o.write(TEST_BYTES);
        o.close();
        byte[] buf = new byte[TEST_BYTES.length];
        int bytesRead = this.mUfs.open(testFile).read(buf);
        if (TEST_BYTES.length != bytesRead || !Arrays.equals(buf, TEST_BYTES)) {
            throw new IOException("Content of the written file is incorrect");
        }
    }

    @RelatedS3Operations(operations={"initiateMultipartUpload", "uploadPart", "completeMultipartUpload", "listObjects"})
    public void createMultipartFileTest() throws IOException {
        int numCopies;
        String testParent = PathUtils.concatPath((Object)this.mTestDirectory, (Object)"createParent");
        String testFile = PathUtils.concatPath((Object)testParent, (Object)"createMultipart");
        try (OutputStream outputStream = this.mUfs.create(testFile, CreateOptions.defaults((AlluxioConfiguration)this.mConfiguration).setCreateParent(true));){
            numCopies = 0x600000 / TEST_BYTES.length;
            for (int i = 0; i < numCopies; ++i) {
                outputStream.write(TEST_BYTES);
            }
        }
        var5_4 = null;
        try (InputStream inputStream = this.mUfs.openExistingFile(testFile);){
            int bytesRead;
            byte[] buf = new byte[numCopies * TEST_BYTES.length];
            for (int offset = 0; offset < buf.length; offset += bytesRead) {
                bytesRead = inputStream.read(buf, offset, buf.length - offset);
                for (int i = 0; i < bytesRead; ++i) {
                    if (TEST_BYTES[(offset + i) % TEST_BYTES.length] == buf[offset + i]) continue;
                    throw new IOException("Content of the written file is incorrect");
                }
            }
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        if (!this.mUfs.isDirectory(testParent)) {
            throw new IOException("The written directory does not exist or is file");
        }
        UfsStatus[] statuses = this.mUfs.listStatus(PathUtils.concatPath((Object)this.mTestDirectory, (Object)"createParent"));
        if (statuses.length != 1) {
            throw new IOException("List status result is incorrect");
        }
    }

    @RelatedS3Operations(operations={"initiateMultipartUpload", "uploadPart", "abortMultipartUploads"})
    public void createAndAbortMultipartFileTest() throws IOException {
        String testFile = PathUtils.concatPath((Object)this.mTestDirectory, (Object)"createAndAbort");
        OutputStream outputStream = this.mUfs.create(testFile);
        int numCopies = 0x600000 / TEST_BYTES.length;
        for (int i = 0; i < numCopies; ++i) {
            outputStream.write(TEST_BYTES);
        }
        System.out.println("Waiting for the in progress upload to be finished so that we can abort it. This file may need longer time to upload which may cause test to fail.");
        CommonUtils.sleepMs((long)10000L);
        this.mUfs.cleanup();
        boolean getS3ExpectedError = false;
        try {
            outputStream.close();
        }
        catch (IOException e) {
            if (e.getMessage().contains("Part upload failed")) {
                getS3ExpectedError = true;
            }
            throw e;
        }
        if (!getS3ExpectedError) {
            throw new IOException("The in progress multipart upload did not be aborted.");
        }
    }

    @RelatedS3Operations(operations={"putObject", "listObjectsV2", "getObjectMetadata"})
    public void listStatusS3RootTest() throws IOException {
        UfsStatus[] rootList = this.mUfs.listStatus("/");
        if (rootList == null || rootList.length == 0) {
            throw new IOException("Unable to list UFS root path");
        }
    }
}

