/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.AbstractValidationTask;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.util.ShellUtils;
import alluxio.util.network.NetworkAddressUtils;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Map;

public final class PortAvailabilityValidationTask
extends AbstractValidationTask {
    private final NetworkAddressUtils.ServiceType mServiceType;
    private final String mOwner;
    private final AlluxioConfiguration mConf;

    public PortAvailabilityValidationTask(NetworkAddressUtils.ServiceType serviceType, String owner, AlluxioConfiguration conf) {
        this.mServiceType = serviceType;
        this.mOwner = owner;
        this.mConf = conf;
    }

    public String getName() {
        return "ValidateAlluxioPorts";
    }

    public ValidationTaskResult validateImpl(Map<String, String> optionsMap) {
        StringBuilder msg = new StringBuilder();
        StringBuilder advice = new StringBuilder();
        if (ShellUtils.isAlluxioRunning((String)this.mOwner)) {
            msg.append(String.format("%s is already running. Skip validation.%n", this.mOwner));
            return new ValidationTaskResult(ValidationUtils.State.SKIPPED, this.getName(), msg.toString(), advice.toString());
        }
        int port = NetworkAddressUtils.getPort((NetworkAddressUtils.ServiceAttributeProvider)this.mServiceType, (AlluxioConfiguration)this.mConf);
        if (!PortAvailabilityValidationTask.isLocalPortAvailable(port)) {
            msg.append(String.format("%s port %d is not available.%n", this.mServiceType.getServiceName(), port));
            advice.append(String.format("Please open your port %s for service %s.%n", port, this.mServiceType.getServiceName()));
            return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
        }
        msg.append("All ports are validated.\n");
        return new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), msg.toString(), advice.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isLocalPortAvailable(int port) {
        try (ServerSocket socket = new ServerSocket(port);){
            socket.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

