/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.AbstractValidationTask;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.Scope;
import alluxio.util.ConfigurationUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class ClusterConfConsistencyValidationTask
extends AbstractValidationTask {
    private final AlluxioConfiguration mConf;

    public ClusterConfConsistencyValidationTask(AlluxioConfiguration conf) {
        this.mConf = conf;
    }

    public String getName() {
        return "ValidateClusterConfConsistency";
    }

    protected ValidationTaskResult validateImpl(Map<String, String> optionMap) throws InterruptedException {
        StringBuilder msg = new StringBuilder();
        StringBuilder advice = new StringBuilder();
        Set masters = ConfigurationUtils.getMasterHostnames((AlluxioConfiguration)this.mConf);
        Set workers = ConfigurationUtils.getWorkerHostnames((AlluxioConfiguration)this.mConf);
        Sets.SetView nodes = Sets.union((Set)masters, (Set)workers);
        HashMap<String, Properties> allProperties = new HashMap<String, Properties>();
        HashSet<String> propertyNames = new HashSet<String>();
        if (masters.isEmpty()) {
            msg.append(String.format("No master nodes specified in %s/masters file. ", this.mConf.getString(PropertyKey.CONF_DIR)));
            advice.append(String.format("Please configure %s to contain the master node hostnames. ", this.mConf.getString(PropertyKey.CONF_DIR)));
            return new ValidationTaskResult(ValidationUtils.State.WARNING, this.getName(), msg.toString(), advice.toString());
        }
        if (workers.isEmpty()) {
            msg.append(String.format("No worker nodes specified in %s/workers file. ", this.mConf.getString(PropertyKey.CONF_DIR)));
            advice.append(String.format("Please configure %s to contain the worker node hostnames. ", this.mConf.getString(PropertyKey.CONF_DIR)));
            return new ValidationTaskResult(ValidationUtils.State.WARNING, this.getName(), msg.toString(), advice.toString());
        }
        ValidationUtils.State state = ValidationUtils.State.OK;
        for (String node : nodes) {
            try {
                Properties props = this.getNodeConf(node);
                allProperties.put(node, props);
                propertyNames.addAll(props.stringPropertyNames());
            }
            catch (IOException e) {
                System.err.format("Unable to retrieve configuration for %s: %s.", node, e.getMessage());
                msg.append(String.format("Unable to retrieve configuration for %s: %s.", node, e.getMessage()));
                advice.append(String.format("Please check the connection from node %s. ", node));
                state = ValidationUtils.State.FAILED;
            }
        }
        block7: for (String propertyName : propertyNames) {
            ValidationUtils.State errLevel;
            String errLabel;
            PropertyKey propertyKey;
            PropertyKey.ConsistencyCheckLevel level;
            if (!PropertyKey.isValid((String)propertyName) || (level = (propertyKey = PropertyKey.fromString((String)propertyName)).getConsistencyLevel()) == PropertyKey.ConsistencyCheckLevel.IGNORE) continue;
            Scope scope = propertyKey.getScope();
            Object targetNodes = ImmutableSet.of();
            if (GrpcUtils.contains((Scope)scope, (Scope)Scope.MASTER)) {
                targetNodes = masters;
            }
            if (GrpcUtils.contains((Scope)scope, (Scope)Scope.WORKER)) {
                targetNodes = Sets.union((Set)targetNodes, (Set)workers);
            }
            if (targetNodes.size() < 2) continue;
            String baseNode = null;
            String baseValue = null;
            boolean isConsistent = true;
            switch (level) {
                case ENFORCE: {
                    errLabel = "Error";
                    errLevel = ValidationUtils.State.FAILED;
                    break;
                }
                case WARN: {
                    errLabel = "Warning";
                    errLevel = ValidationUtils.State.WARNING;
                    break;
                }
                default: {
                    msg.append(String.format("Error: Consistency check level \"%s\" for property \"%s\" is invalid.%n", level.name(), propertyName));
                    advice.append(String.format("Please check property %s.%n", propertyName));
                    state = ValidationUtils.State.FAILED;
                    continue block7;
                }
            }
            Iterator iterator = targetNodes.iterator();
            while (iterator.hasNext()) {
                String remoteNode = (String)iterator.next();
                if (baseNode == null) {
                    baseNode = remoteNode;
                    Properties baselineProps = (Properties)allProperties.get(baseNode);
                    baseValue = baselineProps.getProperty(propertyName);
                    continue;
                }
                String remoteValue = ((Properties)allProperties.get(remoteNode)).getProperty(propertyName);
                if (StringUtils.equals((CharSequence)remoteValue, baseValue)) continue;
                msg.append(String.format("%s: Property \"%s\" is inconsistent between node %s and %s.%n", errLabel, propertyName, baseNode, remoteNode));
                msg.append(String.format(" %s: %s%n %s: %s%n", baseNode, Objects.toString(baseValue, "not set"), remoteNode, Objects.toString(remoteValue, "not set")));
                advice.append(String.format("Please check your settings for property %s on %s and %s.%n", propertyName, baseNode, remoteNode));
                isConsistent = false;
            }
            if (isConsistent) continue;
            state = state == ValidationUtils.State.FAILED ? ValidationUtils.State.FAILED : errLevel;
        }
        return new ValidationTaskResult(state, this.getName(), msg.toString(), advice.toString());
    }

    private Properties getNodeConf(String node) throws IOException {
        String homeDir = this.mConf.getString(PropertyKey.HOME);
        String remoteCommand = String.format("%s/bin/alluxio conf get", homeDir);
        String localCommand = String.format("ssh -o ConnectTimeout=5 -o StrictHostKeyChecking=no -tt %s \"bash %s\"", node, remoteCommand);
        String[] command = new String[]{"bash", "-c", localCommand};
        Properties properties = new Properties();
        Process process = Runtime.getRuntime().exec(command);
        properties.load(process.getInputStream());
        return properties;
    }
}

