/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.hms;

import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.cli.hms.MetastoreValidationTask;
import alluxio.collections.Pair;
import alluxio.util.CommonUtils;
import alluxio.util.ExceptionUtils;
import java.net.InetAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UriCheckTask
extends MetastoreValidationTask<Void, String> {
    private final String mUris;
    private final int mTimeoutMs;

    public UriCheckTask(String inputUri, int timeoutMs) {
        super(null);
        this.mUris = inputUri;
        this.mTimeoutMs = timeoutMs;
    }

    @Override
    Pair<ValidationTaskResult, String> getValidationWithResult() {
        if (this.mUris == null || this.mUris.isEmpty()) {
            String errorMessage = "Hive metastore uris must be provided";
            return new Pair((Object)new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), errorMessage, "Please provide the hive metastore uris"), null);
        }
        List<String> uris = this.mUris.contains(",") ? Arrays.asList(this.mUris.split(",")) : Collections.singletonList(this.mUris);
        for (String rawUri : uris) {
            URI uri;
            try {
                uri = new URI(rawUri);
            }
            catch (Throwable t) {
                return new Pair((Object)new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), ExceptionUtils.asPlainText((Throwable)t), "Please make sure the given hive metastore uri(s) is valid"), null);
            }
            if (uri.getHost() == null || uri.getPort() == -1 || !uri.getScheme().equals("thrift")) {
                String errorMessage = "Invalid hive metastore uris";
                return new Pair((Object)new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), errorMessage, "Please make sure the given hive metastore uri(s) is valid"), null);
            }
            try {
                InetAddress.getByName(uri.getHost());
            }
            catch (Throwable t) {
                return new Pair((Object)new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), ExceptionUtils.asPlainText((Throwable)t), "Please make sure the hostname in given hive metastore uri(s) is resolvable"), null);
            }
            if (CommonUtils.isAddressReachable((String)uri.getHost(), (int)uri.getPort(), (int)this.mTimeoutMs)) continue;
            String errorMessage = "Hive metastore uris are unreachable";
            return new Pair((Object)new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), errorMessage, "Please make sure the given hive metastore uris are reachable. Check that both the host and port are correct."), null);
        }
        return new Pair((Object)new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), "metastore syntax check passed", ""), (Object)this.mUris);
    }

    public String getName() {
        return "HmsUrisCheckTask";
    }
}

