/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.hms;

import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.cli.hms.MetastoreValidationTask;
import alluxio.collections.Pair;
import alluxio.util.ExceptionUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;

public class TableValidationTask
extends MetastoreValidationTask<IMetaStoreClient, String> {
    private static final int GET_TABLE_OBJECT_THRESHOLD = 5;
    private final String mTables;
    private final String mDatabase;

    public TableValidationTask(String database, String tableNames, MetastoreValidationTask<?, IMetaStoreClient> prereq) {
        super(prereq);
        this.mTables = tableNames;
        this.mDatabase = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Pair<ValidationTaskResult, String> getValidationWithResult() throws InterruptedException {
        if (this.mInputTask == null) {
            return new Pair((Object)new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), "Did not have a pre-requisite task to obtain HMS client for table check", ""), null);
        }
        Pair res = this.mInputTask.getValidationWithResult();
        if (((ValidationTaskResult)res.getFirst()).getState() != ValidationUtils.State.OK) {
            return new Pair(res.getFirst(), null);
        }
        try (IMetaStoreClient client = (IMetaStoreClient)res.getSecond();){
            if (this.mTables != null && !this.mTables.isEmpty()) {
                Pair pair = new Pair((Object)this.getTableSchemaTest(client, Arrays.asList(this.mTables.split(","))), null);
                return pair;
            }
            Pair pair = new Pair((Object)this.getAllTableInfoTest(client), null);
            return pair;
        }
    }

    private ValidationTaskResult getAllTableInfoTest(IMetaStoreClient client) {
        List tables;
        String testName = "GetAllTables";
        try {
            tables = client.getAllTables(this.mDatabase);
        }
        catch (Throwable t) {
            return this.addThrowableWarning(testName, t, "Database: " + this.mDatabase);
        }
        if (tables.size() == 0) {
            return new ValidationTaskResult(ValidationUtils.State.OK, testName, String.format("Database (name: %s, tables: %s)", this.mDatabase, tables.toString()), "");
        }
        if (tables.size() > 5) {
            tables = tables.subList(0, 5);
        }
        return this.getTableSchemaTest(client, tables);
    }

    private ValidationTaskResult getTableSchemaTest(IMetaStoreClient client, List<String> tableNames) {
        try {
            StringBuilder tableFieldsOutput = new StringBuilder();
            for (String table : tableNames) {
                String tableFields = client.getSchema(this.mDatabase, table).stream().map(FieldSchema::getName).collect(Collectors.joining(","));
                tableFieldsOutput.append(String.format("Table (name: %s, fields: %s)%n", table, tableFields));
            }
            return new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), tableFieldsOutput.toString(), "");
        }
        catch (Throwable t) {
            return this.addThrowableWarning(this.getName(), t, "tables: " + String.join((CharSequence)",", tableNames));
        }
    }

    private ValidationTaskResult addThrowableWarning(String opName, Throwable t, String opTarget) {
        ValidationTaskResult taskResult = new ValidationTaskResult().setState(ValidationUtils.State.WARNING).setName(opName).setOutput(ExceptionUtils.asPlainText((Throwable)t));
        if (t instanceof InvalidOperationException) {
            taskResult.setAdvice(opName + " is invalid");
        } else if (t instanceof UnknownDBException) {
            taskResult.setAdvice("Please make sure the given database name is valid and existing in the target hive metastore");
        } else if (t instanceof UnknownTableException) {
            taskResult.setAdvice("Please make sure the given table names are valid and existing in the target hive metastore");
        } else {
            taskResult.setAdvice(String.format("Failed to run %s (%s)", opName, opTarget));
        }
        return taskResult;
    }

    public String getName() {
        return "TableValidationCheckTask";
    }
}

