/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.hms;

import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.cli.hms.MetastoreValidationTask;
import alluxio.collections.Pair;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;

public class DatabaseValidationTask
extends MetastoreValidationTask<IMetaStoreClient, String> {
    private final String mDbName;

    public DatabaseValidationTask(String dbName, MetastoreValidationTask<?, IMetaStoreClient> prereq) {
        super(prereq);
        this.mDbName = dbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Pair<ValidationTaskResult, String> getValidationWithResult() throws InterruptedException {
        if (this.mInputTask == null) {
            return new Pair((Object)new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), "Did not have a pre-requisite task to obtain HMS client for database check", ""), null);
        }
        Pair res = this.mInputTask.getValidationWithResult();
        if (((ValidationTaskResult)res.getFirst()).getState() != ValidationUtils.State.OK) {
            return new Pair(res.getFirst(), null);
        }
        try (IMetaStoreClient client = (IMetaStoreClient)res.getSecond();){
            Database database = client.getDatabase(this.mDbName);
            Pair pair = new Pair((Object)new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), String.format("Database (name: %s, description: %s)", database.getName(), database.getDescription()), ""), (Object)this.mDbName);
            return pair;
        }
    }

    public String getName() {
        return "getDatabaseCheck";
    }
}

