/*
 * Decompiled with CFR 0.152.
 */
package alluxio.jnifuse.utils;

import alluxio.jnifuse.utils.Environment;
import alluxio.jnifuse.utils.VersionPreference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibraryLoader {
    private static final Logger LOG = LoggerFactory.getLogger(NativeLibraryLoader.class);
    private static final NativeLibraryLoader INSTANCE = new NativeLibraryLoader();
    private static final AtomicReference<LoadState> LOAD_STATE = new AtomicReference<LoadState>(LoadState.NOT_LOADED);
    private static final String TEMP_FILE_PREFIX = "libjnifuse";
    private static final String TEMP_FILE_SUFFIX = Environment.getJniLibraryExtension();

    public static LoadState getLoadState() {
        return LOAD_STATE.get();
    }

    private static void setLoadState(LoadState loadState) {
        LOAD_STATE.set(loadState);
    }

    public static NativeLibraryLoader getInstance() {
        return INSTANCE;
    }

    private Optional<UnsatisfiedLinkError> tryLoad(Load load) throws IOException {
        try {
            load.load();
            return Optional.empty();
        }
        catch (UnsatisfiedLinkError ule) {
            return Optional.of(ule);
        }
    }

    private Optional<UnsatisfiedLinkError> load(String sharedLibraryName, String jniLibraryName, String sharedLibraryFileName, String jniLibraryFileName, String tmpDir) throws IOException {
        Optional<UnsatisfiedLinkError> err = this.tryLoad(() -> {
            System.loadLibrary(sharedLibraryName);
            LOG.info("Loaded {} by System.loadLibrary.", (Object)sharedLibraryName);
        });
        if (!err.isPresent()) {
            return err;
        }
        err = this.tryLoad(() -> {
            System.loadLibrary(jniLibraryName);
            LOG.info("Loaded {} by System.loadLibrary.", (Object)jniLibraryName);
        });
        if (!err.isPresent()) {
            return err;
        }
        return this.tryLoad(() -> this.loadLibraryFromJar(sharedLibraryFileName, jniLibraryFileName, tmpDir));
    }

    private Optional<UnsatisfiedLinkError> load2(String tmpDir) throws IOException {
        String JNI_LIBRARY_FILE_NAME;
        String SHARED_LIBRARY_NAME = Environment.getSharedLibraryName("jnifuse");
        String SHARED_LIBRARY_FILE_NAME = Environment.getSharedLibraryFileName("jnifuse");
        String JNI_LIBRARY_NAME = Environment.getJniLibraryName("jnifuse");
        Optional<UnsatisfiedLinkError> err = this.load(SHARED_LIBRARY_NAME, JNI_LIBRARY_NAME, SHARED_LIBRARY_FILE_NAME, JNI_LIBRARY_FILE_NAME = Environment.getJniLibraryFileName("jnifuse"), tmpDir);
        if (!err.isPresent()) {
            LOG.info("Loaded libjnifuse with libfuse version 2.");
            NativeLibraryLoader.setLoadState(LoadState.LOADED_2);
        }
        return err;
    }

    private Optional<UnsatisfiedLinkError> load3(String tmpDir) throws IOException {
        String JNI_LIBRARY_FILE_NAME;
        String SHARED_LIBRARY_NAME = Environment.getSharedLibraryName("jnifuse3");
        String SHARED_LIBRARY_FILE_NAME = Environment.getSharedLibraryFileName("jnifuse3");
        String JNI_LIBRARY_NAME = Environment.getJniLibraryName("jnifuse3");
        Optional<UnsatisfiedLinkError> err = this.load(SHARED_LIBRARY_NAME, JNI_LIBRARY_NAME, SHARED_LIBRARY_FILE_NAME, JNI_LIBRARY_FILE_NAME = Environment.getJniLibraryFileName("jnifuse3"), tmpDir);
        if (!err.isPresent()) {
            LOG.info("Loaded libjnifuse with libfuse version 3.");
            NativeLibraryLoader.setLoadState(LoadState.LOADED_3);
        }
        return err;
    }

    public synchronized void loadLibrary(VersionPreference preference, String tmpDir) throws IOException {
        if (preference == VersionPreference.VERSION_2) {
            Optional<UnsatisfiedLinkError> err = this.load2(tmpDir);
            if (err.isPresent()) {
                throw err.get();
            }
            return;
        }
        if (preference == VersionPreference.VERSION_3) {
            Optional<UnsatisfiedLinkError> err = this.load3(tmpDir);
            if (err.isPresent()) {
                throw err.get();
            }
            return;
        }
        Optional<UnsatisfiedLinkError> err = this.load2(tmpDir);
        if (!err.isPresent()) {
            return;
        }
        err = this.load3(tmpDir);
        if (!err.isPresent()) {
            return;
        }
        throw new UnsatisfiedLinkError("Neither libfuse2 nor libfuse3 can be loaded.");
    }

    void loadLibraryFromJar(String sharedLibraryFileName, String jniLibraryFileName, String tmpDir) throws IOException {
        if (LOAD_STATE.get() == LoadState.NOT_LOADED) {
            String libPath = this.loadLibraryFromJarToTemp(sharedLibraryFileName, jniLibraryFileName, tmpDir).getAbsolutePath();
            System.load(libPath);
            LOG.info("Loaded lib by jar from path {}.", (Object)libPath);
        }
    }

    File loadLibraryFromJarToTemp(String sharedLibraryFileName, String jniLibraryFileName, String tmpDir) throws IOException {
        File temp;
        if (tmpDir == null || tmpDir.isEmpty()) {
            temp = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
        } else {
            temp = new File(tmpDir, jniLibraryFileName);
            if (temp.exists() && !temp.delete()) {
                throw new RuntimeException("File: " + temp.getAbsolutePath() + " already exists and cannot be removed.");
            }
            if (!temp.createNewFile()) {
                throw new RuntimeException("File: " + temp.getAbsolutePath() + " could not be created.");
            }
        }
        if (!temp.exists()) {
            throw new RuntimeException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        temp.deleteOnExit();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(sharedLibraryFileName);){
            if (is == null) {
                throw new RuntimeException(sharedLibraryFileName + " was not found inside JAR.");
            }
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return temp;
    }

    private NativeLibraryLoader() {
    }

    static interface Load {
        public void load() throws IOException;
    }

    public static enum LoadState {
        NOT_LOADED,
        LOADED_2,
        LOADED_3;

    }
}

