/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.maven.plugin;

import java.io.File;
import java.io.IOException;
import org.alfresco.repo.module.tool.ModuleManagementTool;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class InstallMojo
extends AbstractMojo {
    private static final String WEBAPP_MANIFEST_PATH = "META-INF" + File.separator + "MANIFEST.MF";
    private static final String WEBAPP_DESCRIPTOR_PATH = "WEB-INF" + File.separator + "web.xml";
    private File ampLocation;
    private File warLocation;
    private boolean verbose;
    private boolean force;
    private boolean backup;
    private boolean skipWarManifestCheck;
    private boolean skipAmpInstallation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipAmpInstallation) {
            this.getLog().info((CharSequence)"AMP Installation is skipped via configuration");
            return;
        }
        this.checkParams();
        ModuleManagementTool mmt = new ModuleManagementTool();
        mmt.setVerbose(this.verbose);
        if (this.ampLocation.isDirectory()) {
            try {
                this.getLog().info((CharSequence)("Installing all AMPs from directory " + this.ampLocation.getAbsolutePath() + " into WAR/exploded webapp at " + this.warLocation.getAbsolutePath()));
                mmt.installModules(this.ampLocation.getAbsolutePath(), this.warLocation.getAbsolutePath(), false, this.force, this.backup);
                this.getLog().info((CharSequence)"AMPs installed successfully");
            }
            catch (IOException e) {
                throw new MojoExecutionException("ampLocation " + this.ampLocation.getAbsolutePath() + " did not contain AMP files - AMP installation cannot proceed");
            }
        } else if (this.ampLocation.isFile()) {
            this.getLog().info((CharSequence)("Installing AMP " + this.ampLocation.getAbsolutePath() + " into WAR/exploded webapp at " + this.warLocation.getAbsolutePath()));
            mmt.installModule(this.ampLocation.getAbsolutePath(), this.warLocation.getAbsolutePath(), false, this.force, this.backup);
            this.getLog().info((CharSequence)"AMP installed successfully");
        } else {
            throw new MojoFailureException("ampLocation " + this.ampLocation.getAbsolutePath() + " was neither an AMP file or a folder containing AMP files - AMP installation cannot proceed");
        }
    }

    private void checkParams() throws MojoExecutionException {
        if (this.ampLocation == null || !this.ampLocation.exists()) {
            throw new MojoExecutionException("No AMP file(s) found in " + this.ampLocation.getAbsolutePath() + " - AMP installation cannot proceed");
        }
        if (this.warLocation == null || !this.warLocation.exists()) {
            throw new MojoExecutionException("No WAR file found in " + this.warLocation.getAbsolutePath() + " - AMP installation cannot proceed");
        }
        File descriptor = new File(this.warLocation.getPath() + File.separator + WEBAPP_DESCRIPTOR_PATH);
        if (this.warLocation.isDirectory() && !descriptor.exists()) {
            throw new MojoExecutionException("No webapp found in " + descriptor.getAbsolutePath() + ". AMP installation cannot proceed. Are you binding amp:install to the right phase?");
        }
        File manifest = new File(this.warLocation.getPath() + File.separator + WEBAPP_MANIFEST_PATH);
        if (!this.skipWarManifestCheck && this.warLocation.isDirectory() && !manifest.exists()) {
            throw new MojoExecutionException("No MANIFEST.MF found in " + manifest.getAbsolutePath() + ". AMP installation cannot proceed. Are you binding amp:install to the right phase?");
        }
    }
}

