/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import org.aion4j.avm.helper.api.Log;
import org.aion4j.avm.helper.remote.RemoteAVMNode;
import org.aion4j.avm.helper.util.ConfigUtil;
import org.aion4j.maven.avm.impl.MavenLog;
import org.aion4j.maven.avm.mojo.AVMBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="unlock", aggregator=true)
public class AVMUnlockMojo
extends AVMBaseMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isLocal()) {
            throw new MojoExecutionException("aion4j:unlock is only supported for remote Aion kernel");
        }
        String web3RpcUrl = this.resolveWeb3rpcUrl();
        if (web3RpcUrl == null || web3RpcUrl.isEmpty()) {
            this.getLog().error((CharSequence)"web3rpc.url cannot be null");
            this.printHelp();
            throw new MojoExecutionException("Invalid args - web3rpc.url cannot be null");
        }
        String address = ConfigUtil.getProperty((String)"address");
        String password = ConfigUtil.getProperty((String)"password");
        if (address == null || address.isEmpty() || password == null || password.isEmpty()) {
            this.printHelp();
            throw new MojoExecutionException("Invalid args - address / password is empty");
        }
        RemoteAVMNode remoteAVMNode = new RemoteAVMNode(web3RpcUrl, (Log)MavenLog.getLog(this.getLog()));
        boolean status = remoteAVMNode.unlock(address, password);
        if (!status) {
            this.getLog().info((CharSequence)"Account unlock failed");
            throw new MojoExecutionException("Account unlock failed");
        }
        this.getLog().info((CharSequence)"Account unlocked successfully");
    }

    private void printHelp() {
        this.getLog().error((CharSequence)"Usage:");
        this.getLog().error((CharSequence)"mvn aion4j:unlock -Dweb3rpc.url=http://host:port -Daddress=<address> -Dpassword=<password>");
    }
}

