/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.aion4j.avm.helper.util.ConfigUtil;
import org.aion4j.maven.avm.mojo.AVMAbstractBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="postpack", defaultPhase=LifecyclePhase.PACKAGE)
public class AVMPostProcessMojo
extends AVMAbstractBaseMojo {
    private static final String DISABLE_JAR_OPTIMIZATION = "disableJarOptimization";

    @Override
    protected void preexecuteLocalAvm() throws MojoExecutionException {
    }

    @Override
    protected void executeRemote() throws MojoExecutionException {
        this.startPostProcessing();
    }

    @Override
    protected void executeLocalAvm(ClassLoader avmClassloader, Object localAvmInstance) throws MojoExecutionException {
        this.startPostProcessing();
    }

    private void startPostProcessing() throws MojoExecutionException {
        Path path = Paths.get(this.getDappJar(), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            this.getLog().info((CharSequence)"Post processing skipped");
            return;
        }
        this.backupOriginalJar(Paths.get(this.getDappJar(), new String[0]));
        byte[] jarBytes = this.readJarContent();
        jarBytes = this.abiCompile(this.getLocalAVMClass(), jarBytes);
        boolean disableJarOptimization = ConfigUtil.getAvmConfigurationBooleanProps((String)DISABLE_JAR_OPTIMIZATION, (boolean)false);
        if (!disableJarOptimization) {
            jarBytes = this.optimizeJar(this.getLocalAVMClass(), jarBytes, ConfigUtil.getAvmConfigurationBooleanProps((String)"preserveDebuggability", (boolean)false));
        }
        this.writeJarContent(jarBytes);
    }

    private byte[] readJarContent() throws MojoExecutionException {
        try {
            Path dAppJarPath = Paths.get(this.getDappJar(), new String[0]);
            byte[] jarBytes = Files.readAllBytes(dAppJarPath);
            return jarBytes;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("Error reading contract jar content : " + this.getDappJar(), new Object[0]), (Throwable)e);
            throw new MojoExecutionException("Error reading contract jar content: " + this.getDappJar(), e);
        }
    }

    private void writeJarContent(byte[] bytes) throws MojoExecutionException {
        try {
            Path compileJarPath = Paths.get(this.getDappJar(), new String[0]);
            Files.write(compileJarPath, bytes, new OpenOption[0]);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("Error writing contract jar content : " + this.getDappJar(), new Object[0]), (Throwable)e);
            throw new MojoExecutionException("Error writing contract jar content : " + this.getDappJar(), e);
        }
    }

    private byte[] abiCompile(Class localAvmClazz, byte[] jarBytes) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Post compile the jar >> " + this.dappJar));
            String abiPath = this.getAbiPath();
            Method compileJarBytesMethod = localAvmClazz.getMethod("compileJarBytesAndWriteAbi", byte[].class, OutputStream.class);
            byte[] compiledBytes = (byte[])compileJarBytesMethod.invoke(null, jarBytes, new FileOutputStream(new File(abiPath)));
            return compiledBytes;
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)String.format("Contract Jar post compilation failed", new Object[0]), (Throwable)ex);
            throw new MojoExecutionException("Contract Jar post compilation failed", ex);
        }
    }

    private String getAbiPath() {
        String dappJar = this.getDappJar();
        if (dappJar.endsWith(".jar")) {
            dappJar = dappJar.replace(".jar", ".abi");
            return dappJar;
        }
        return dappJar + ".abi";
    }

    private byte[] optimizeJar(Class localAvmClazz, byte[] jarBytes, boolean debugMode) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Optimizing the jar content >> " + this.dappJar));
            Method optimizeJarBytesMethod = localAvmClazz.getMethod("optimizeJarBytes", byte[].class, Boolean.TYPE);
            byte[] optimizedBytes = (byte[])optimizeJarBytesMethod.invoke(null, jarBytes, debugMode);
            return optimizedBytes;
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)String.format("Contract Jar optimization failed", new Object[0]), (Throwable)ex);
            throw new MojoExecutionException("Contract Jar optimization failed", ex);
        }
    }

    private void backupOriginalJar(Path dAppJarPath) {
        try {
            String backupJar = dAppJarPath.getParent().toAbsolutePath() + File.separator + "original-" + dAppJarPath.toFile().getName();
            Files.copy(dAppJarPath, Paths.get(backupJar, new String[0]), new CopyOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void postExecuteLocalAvm(Object localAvmInstance) throws MojoExecutionException {
    }

    @Override
    protected Object getLocalAvmImplInstance(ClassLoader avmClassloader) {
        return null;
    }
}

