/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import java.lang.reflect.Method;
import java.math.BigInteger;
import org.aion4j.avm.helper.api.Log;
import org.aion4j.avm.helper.crypto.Account;
import org.aion4j.avm.helper.crypto.AccountGenerator;
import org.aion4j.avm.helper.remote.RemoteAVMNode;
import org.aion4j.avm.helper.util.ConfigUtil;
import org.aion4j.maven.avm.impl.MavenLog;
import org.aion4j.maven.avm.mojo.AVMLocalRuntimeBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="create-account", aggregator=true)
public class AVMCreateAccountMojo
extends AVMLocalRuntimeBaseMojo {
    @Override
    protected void preexecuteLocalAvm() throws MojoExecutionException {
    }

    @Override
    protected void executeLocalAvm(ClassLoader avmClassloader, Object localAvmInstance) throws MojoExecutionException {
        try {
            String addressToCreate = ConfigUtil.getProperty((String)"address");
            String balance = ConfigUtil.getProperty((String)"balance");
            if ((addressToCreate == null || addressToCreate.isEmpty()) && (balance == null || balance.isEmpty())) {
                this.generateClientSideAccount();
            } else {
                Object response;
                Method createAccountMethod = localAvmInstance.getClass().getMethod("createAccountWithBalance", String.class, BigInteger.class);
                if (balance == null || balance.isEmpty()) {
                    this.getLog().error((CharSequence)"Usage:\n mvn create-account -Daddress a0xxxxx -Dbalance=2000000000");
                }
                if (addressToCreate == null || addressToCreate.isEmpty()) {
                    Account account = AccountGenerator.newAddress();
                    if (account.getAddress() == null || account.getAddress().isEmpty()) {
                        throw new MojoExecutionException("Unable to generate a new address. Please provide an address as argument. Usage:\n mvn create-account [-Daddress a0xxxxx] -Dbalance=2000000000");
                    }
                    addressToCreate = account.getAddress();
                }
                if (((Boolean)(response = createAccountMethod.invoke(localAvmInstance, addressToCreate, new BigInteger(balance.trim())))).booleanValue()) {
                    this.getLog().info((CharSequence)String.format("Account creation successful", new Object[0]));
                    this.getLog().info((CharSequence)("Address: " + addressToCreate));
                    this.getLog().info((CharSequence)("Balance: " + balance.trim()));
                } else {
                    this.getLog().info((CharSequence)"Account creation failed. Please check if account exists");
                }
            }
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Account creation failed", (Throwable)ex);
            throw new MojoExecutionException("Account creation failed", ex);
        }
    }

    @Override
    protected void executeRemote() throws MojoExecutionException {
        boolean kernelManaged;
        String password = ConfigUtil.getProperty((String)"password");
        boolean bl = kernelManaged = ConfigUtil.getProperty((String)"kernel") != null ? Boolean.parseBoolean(ConfigUtil.getProperty((String)"kernel")) : false;
        if (kernelManaged) {
            RemoteAVMNode remoteAVMNode = new RemoteAVMNode(this.resolveWeb3rpcUrl(), (Log)MavenLog.getLog(this.getLog()));
            try {
                String newAddress = remoteAVMNode.createAccount(password);
                this.getLog().info((CharSequence)String.format("Account creation successful", new Object[0]));
                this.getLog().info((CharSequence)("Address : " + newAddress));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Account creation failed", e);
            }
        } else {
            this.generateClientSideAccount();
        }
    }

    private void generateClientSideAccount() {
        Account account = AccountGenerator.newAddress();
        Object address = account.getAddress();
        if (!((String)address).startsWith("0x")) {
            address = "0x" + (String)address;
        }
        this.getLog().info((CharSequence)String.format("Account creation successful", new Object[0]));
        this.getLog().info((CharSequence)("Address : " + (String)address));
        this.getLog().info((CharSequence)("Private Key: " + account.getPrivateKey()));
    }
}

