/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import org.aion4j.maven.avm.mojo.AVMBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="clean", defaultPhase=LifecyclePhase.CLEAN)
public class AVMCleanMojo
extends AVMBaseMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        String storageDir = this.project.getBasedir() + File.separator + "storage";
        try {
            Path pathToBeDeleted = Paths.get(storageDir, new String[0]);
            if (Files.exists(pathToBeDeleted, new LinkOption[0])) {
                this.getLog().info((CharSequence)("Deleting storage folder " + storageDir));
                Files.walk(pathToBeDeleted, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to delete folder " + storageDir);
        }
    }
}

