/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.aion4j.avm.helper.exception.LocalAVMException;
import org.aion4j.maven.avm.mojo.AVMAbstractBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="class-verifier", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class AVMClassVerifierMojo
extends AVMAbstractBaseMojo {
    private static final String AVM_USERLIB_JAR = "org-aion-avm-userlib.jar";

    @Override
    protected void preexecuteLocalAvm() throws MojoExecutionException {
    }

    @Override
    protected void executeLocalAvm(ClassLoader avmClassloader, Object classVerfierImpl) throws MojoExecutionException {
        try {
            Method setInputclassesMethod = classVerfierImpl.getClass().getMethod("setInputClasses", List.class);
            Method verifyMethod = classVerfierImpl.getClass().getMethod("verify", String.class, String.class);
            String outputDir = this.project.getBuild().getOutputDirectory();
            this.getLog().debug((CharSequence)("Output folder : " + outputDir));
            Path outputPath = Paths.get(outputDir, new String[0]);
            List paths = Files.walk(outputPath, new FileVisitOption[0]).filter(f -> f.toFile().getName().endsWith(".class")).collect(Collectors.toList());
            ArrayList<String> inputClasses = new ArrayList<String>();
            List<String> userLibClasses = this.getUserlibApiClasses();
            inputClasses.addAll(userLibClasses);
            for (Path path : paths) {
                String inputDotClassName = this.getClassNameWithDot(outputPath, path);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Dot classname" + inputDotClassName));
                }
                if (inputDotClassName.contains("module-info")) continue;
                inputClasses.add(inputDotClassName);
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().info((CharSequence)("Input classes for verification: " + inputClasses));
            }
            setInputclassesMethod.invoke(classVerfierImpl, inputClasses);
            ArrayList<VerificationError> errors = new ArrayList<VerificationError>();
            for (Path path : paths) {
                String fullPath = path.toAbsolutePath().toString();
                String className = this.getClassNameWithDot(outputPath, path);
                if (className.startsWith("org.aion.avm") || className.equals("module-info")) continue;
                this.getLog().debug((CharSequence)("Let's verify class : " + className));
                try {
                    verifyMethod.invoke(classVerfierImpl, className, fullPath);
                }
                catch (Exception e) {
                    errors.add(new VerificationError(e, fullPath));
                }
            }
            if (errors.size() > 0) {
                this.getLog().error((CharSequence)"AVM verification failed with the following reasons:");
                for (VerificationError ve : errors) {
                    try {
                        this.getLog().error((CharSequence)String.format("Verification failed for %s, error: %s", ve.file, ve.exception.getCause().getMessage()));
                        this.getLog().debug((CharSequence)String.format("Verification failed for %s", ve.file), (Throwable)ve.exception);
                    }
                    catch (Exception e) {
                        this.getLog().error((Throwable)ve.exception);
                    }
                }
                throw new MojoExecutionException("AVM Verification failed");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("[Verification Error]", e);
        }
    }

    private String getClassNameWithDot(Path outputPath, Path path) {
        Path relativePath = outputPath.relativize(path);
        String relPathAsString = relativePath.toString();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Class file relative path: " + relPathAsString));
        }
        String inputDotClassName = relPathAsString.substring(0, relPathAsString.length() - 6);
        inputDotClassName = inputDotClassName.replace(File.separator, ".");
        return inputDotClassName;
    }

    private List<String> getUserlibApiClasses() {
        String libFolderPath = this.getAvmLibDir();
        File libFolder = new File(libFolderPath);
        File userLibJarFile = new File(libFolder, AVM_USERLIB_JAR);
        if (!userLibJarFile.exists()) {
            this.getLog().error((CharSequence)("org-aion-avm-userlib.jar not found in " + libFolder.getAbsolutePath()));
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> userLibClasses = new ArrayList<String>();
        try (JarFile jar = new JarFile(userLibJarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String classNameWithSlash = entry.getName();
                if (!classNameWithSlash.endsWith(".class")) continue;
                classNameWithSlash = classNameWithSlash.substring(0, classNameWithSlash.length() - 6);
                String classNameWithDot = classNameWithSlash.replace("/", ".");
                classNameWithDot = classNameWithDot.replace("\\", ".");
                userLibClasses.add(classNameWithDot);
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Failed reading org-aion-avm-userlib.jar", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
        return userLibClasses;
    }

    @Override
    protected void postExecuteLocalAvm(Object localAvmInstance) throws MojoExecutionException {
    }

    @Override
    protected Object getLocalAvmImplInstance(ClassLoader avmClassloader) {
        try {
            Class<?> clazz = avmClassloader.loadClass("org.aion4j.avm.helper.local.AVMClassVerifier");
            Constructor<?> localAvmVerifierConstructor = clazz.getConstructor(Boolean.TYPE);
            Object classVerifierInstance = localAvmVerifierConstructor.newInstance(this.isLocal());
            return classVerifierInstance;
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"Error creating LocalAvmNode instance", (Throwable)e);
            throw new LocalAVMException(e);
        }
    }

    class VerificationError {
        public Exception exception;
        public String file;

        public VerificationError(Exception ex, String file) {
            this.exception = ex;
            this.file = file;
        }
    }
}

