/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import org.aion4j.avm.helper.util.ConfigUtil;
import org.aion4j.avm.helper.util.ResultCache;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AVMBaseMojo
extends AbstractMojo {
    @Parameter(property="avm-lib-dir", defaultValue="${project.basedir}/lib")
    protected String avmLibDir;
    @Parameter(property="dapp-jar", defaultValue="${project.build.directory}/${project.build.finalName}.jar")
    protected String dappJar;
    @Parameter(property="mode", defaultValue="local")
    protected String mode;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="storage-path", defaultValue="${project.build.directory}/storage")
    protected String storagePath;
    @Parameter(property="local-default-address", defaultValue="a025f4fd54064e869f158c1b4eb0ed34820f67e60ee80a53b469f725efc06378")
    protected String localDefaultAddress;
    @Parameter(property="web3rpcUrl", defaultValue="")
    protected String web3rpcUrl;
    private ResultCache cache;

    public String getAvmLibDir() {
        return this.avmLibDir;
    }

    public void setAvmLibDir(String avmLibDir) {
        this.avmLibDir = avmLibDir;
    }

    public String getDappJar() {
        return this.dappJar;
    }

    public void setDappJar(String dappJar) {
        this.dappJar = dappJar;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    public String getLocalDefaultAddress() {
        return this.localDefaultAddress;
    }

    public void setLocalDefaultAddress(String localDefaultAddress) {
        this.localDefaultAddress = localDefaultAddress;
    }

    public String getWeb3rpcUrl() {
        return this.web3rpcUrl;
    }

    public void setWeb3rpcUrl(String web3rpcUrl) {
        this.web3rpcUrl = web3rpcUrl;
    }

    public boolean isLocal() {
        return "local".equals(this.getMode());
    }

    protected String resolveWeb3rpcUrl() throws MojoExecutionException {
        String web3RpcUrl = ConfigUtil.getProperty((String)"web3rpc.url");
        if (web3RpcUrl == null || web3RpcUrl.isEmpty()) {
            web3RpcUrl = this.getWeb3rpcUrl();
        }
        if (web3RpcUrl == null || web3RpcUrl.isEmpty()) {
            this.getLog().error((CharSequence)"web3rpc.url cannot be null. Please set it through -Dweb3rpc.url in maven command line or environment variable as web3rpc_url or in plugin configuration as web3rpcUrl property.");
            throw new MojoExecutionException("Invalid args. web3rpc.url cannot be null. Please set it through -Dweb3rpc.url in maven command line  or environment variable as web3rpc_url or in plugin configuration as web3rpcUrl property.");
        }
        this.getLog().info((CharSequence)("web3rpc.url is set to " + web3RpcUrl));
        return web3RpcUrl;
    }

    protected String getAddress() throws MojoExecutionException {
        return ConfigUtil.getProperty((String)"address");
    }

    protected long getGas() {
        String gasString = ConfigUtil.getProperty((String)"gas");
        try {
            if (gasString != null && !gasString.isEmpty()) {
                return Long.parseLong(gasString.trim());
            }
            return 0L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    protected long getGasPrice() {
        String getPriceString = ConfigUtil.getProperty((String)"gasPrice");
        try {
            if (getPriceString != null && !getPriceString.isEmpty()) {
                return Long.parseLong(getPriceString.trim());
            }
            return 0L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    protected String getPrivateKey() {
        if (this.isLocal()) {
            return null;
        }
        String pk = ConfigUtil.getProperty((String)"pk");
        return pk;
    }

    protected ResultCache getCache() {
        if (this.cache == null) {
            this.cache = new ResultCache(this.project.getName(), this.isLocal() ? this.getStoragePath() : this.project.getBuild().getOutputDirectory());
        }
        return this.cache;
    }
}

