/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.codegenerator.generators.testsupport;

import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import org.aion4j.avm.codegenerator.api.exception.CodeGenerationException;
import org.aion4j.avm.codegenerator.api.generator.BaseGenerator;
import org.aion4j.avm.codegenerator.api.impl.VelocityTemplateGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSupportGenerator
extends BaseGenerator {
    private final Logger logger = LoggerFactory.getLogger(TestSupportGenerator.class);
    private final String TEST_IMPL_TEMPLATE = "templates/test/TestImpl.java.vm";
    private final String REQUEST_CONTEXT_TEMPLATE = "templates/test/RequestContext.java.vm";
    private final String RESPONSE_CONTEXT_TEMPLATE = "templates/test/ResponseContext.java.vm";

    public TestSupportGenerator(boolean verbose) {
        this.templateGenerator = new VelocityTemplateGenerator();
        this.verbose = verbose;
    }

    @Override
    protected void doGenerate(String baseDir, String packageDir, HashMap<String, Object> data) {
        try {
            FileWriter contractTestImplWriter = new FileWriter(new File(packageDir, data.get("className") + "TestImpl.java"));
            this.generateFromTemplate("templates/test/TestImpl.java.vm", data, contractTestImplWriter);
            FileWriter requestContextWriter = new FileWriter(new File(packageDir, "RequestContext.java"));
            this.generateFromTemplate("templates/test/RequestContext.java.vm", data, requestContextWriter);
            FileWriter responseContextWriter = new FileWriter(new File(packageDir, "ResponseContext.java"));
            this.generateFromTemplate("templates/test/ResponseContext.java.vm", data, responseContextWriter);
        }
        catch (Exception e) {
            throw new CodeGenerationException("Error in generting test support code", e);
        }
    }

    @Override
    protected String formatSource(String source) {
        String formattedSource;
        block3: {
            formattedSource = null;
            try {
                formattedSource = new Formatter().formatSource(source);
            }
            catch (FormatterException e) {
                if (this.verbose) {
                    this.logger.info("Error formatting generated source : \n" + source, (Throwable)e);
                }
                formattedSource = source;
                if (this.ignoreFormattingError) break block3;
                throw new CodeGenerationException("Some error in generated code", (Exception)((Object)e));
            }
        }
        return formattedSource;
    }
}

