/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.codegenerator.generators.clientjs;

import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import org.aion4j.avm.codegenerator.api.exception.CodeGenerationException;
import org.aion4j.avm.codegenerator.api.generator.BaseGenerator;
import org.aion4j.avm.codegenerator.api.impl.VelocityTemplateGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsClientGenerator
extends BaseGenerator {
    private final Logger logger = LoggerFactory.getLogger(JsClientGenerator.class);
    private final String CONTRACT_DEPLOY_JS_TEMPLATE = "templates/client/js/contract-deploy.js.vm";
    private final String CONTRACT_DEPLOY_WITH_ABI_JS_TEMPLATE = "templates/client/js/contract-deploy-abi.js.vm";
    private final String CONTRACT_CALL_JS_TEMPLATE = "templates/client/js/contract.js.vm";
    private final String CONTRACT_CALL_WITH_ABI_JS_TEMPLATE = "templates/client/js/contract-abi.js.vm";
    private final String PACKAGE_JSON_TEMPLATE = "templates/client/js/package.json.vm";

    public JsClientGenerator(boolean verbose) {
        this.templateGenerator = new VelocityTemplateGenerator();
        this.verbose = verbose;
    }

    @Override
    protected void doGenerate(String baseDir, String packageDir, HashMap<String, Object> data) {
        try {
            data.put("mode", "node");
            FileWriter contractDeployWriter = new FileWriter(new File(baseDir, "contract-deploy.js"));
            this.generateFromTemplate("templates/client/js/contract-deploy.js.vm", data, contractDeployWriter);
            FileWriter contractDeployAbiWriter = new FileWriter(new File(baseDir, "contract-deploy-abi.js"));
            this.generateFromTemplate("templates/client/js/contract-deploy-abi.js.vm", data, contractDeployAbiWriter);
            FileWriter contractCallWriter = new FileWriter(new File(baseDir, "contract.js"));
            this.generateFromTemplate("templates/client/js/contract.js.vm", data, contractCallWriter);
            FileWriter contractCallAbiWriter = new FileWriter(new File(baseDir, "contract-abi.js"));
            this.generateFromTemplate("templates/client/js/contract-abi.js.vm", data, contractCallAbiWriter);
            File packageJson = new File(baseDir, "package.json");
            if (!packageJson.exists()) {
                this.generateFromTemplate("templates/client/js/package.json.vm", data, new FileWriter(packageJson));
            }
        }
        catch (Exception e) {
            throw new CodeGenerationException("Error in generting js client code", e);
        }
    }

    @Override
    protected boolean isPackageFolderCreationRequired() {
        return false;
    }
}

