/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.codegenerator.api.impl;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.aion4j.avm.codegenerator.api.TemplateGenerator;
import org.aion4j.avm.codegenerator.api.exception.TemplateNotFoundException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class VelocityTemplateGenerator
implements TemplateGenerator {
    VelocityEngine velocityEngine = null;

    public VelocityTemplateGenerator() {
        this.init();
    }

    public void init() {
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.setProperty("resource.loaders", (Object)"classpath");
        this.velocityEngine.setProperty("resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
        this.velocityEngine.init();
    }

    @Override
    public void generate(String template, HashMap<String, Object> data, Writer writer) {
        Template t = null;
        try {
            t = this.velocityEngine.getTemplate(template);
        }
        catch (ResourceNotFoundException e) {
            throw new TemplateNotFoundException("Template not found : " + template, (Exception)((Object)e));
        }
        if (t == null) {
            throw new TemplateNotFoundException("Template not found : " + template);
        }
        VelocityContext context = new VelocityContext();
        if (data != null) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                context.put(entry.getKey(), entry.getValue());
            }
        }
        t.merge((Context)context, writer);
    }
}

