/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.translators.soil;

import java.util.HashMap;
import java.util.Map;
import org.agmip.translators.soil.LayerReducer;
import org.agmip.translators.soil.LayerReducerDecorator;
import org.agmip.translators.soil.LayerReducerUtil;
import org.agmip.translators.soil.WaterReserveCriteria;

public class SAReducerDecorator
implements LayerReducerDecorator {
    public static String ICBL = "icbl";
    public static String ICH2O = "ich2o";
    public static String ICNO3 = "icno3";
    public static String ICNH4 = "icnh4";
    private WaterReserveCriteria criteria;
    private String[] allParams = new String[]{LayerReducer.SLLL, LayerReducer.SLDUL, LayerReducer.SLBDM, LayerReducer.SKSAT, LayerReducer.SLOC, ICH2O, LayerReducer.SLLB, ICNO3, ICNH4};

    public SAReducerDecorator() {
        this.criteria = new WaterReserveCriteria();
    }

    public WaterReserveCriteria getCriteria() {
        return this.criteria;
    }

    public Float computeInitialConditions(String key, Map<String, String> fullCurrentSoil, Map<String, String> previousSoil) {
        Float newValue = Float.valueOf(Float.parseFloat(fullCurrentSoil.get(key)) * Float.parseFloat(fullCurrentSoil.get(LayerReducer.SLLB)) + Float.parseFloat(previousSoil.get(key)) * Float.parseFloat(previousSoil.get(LayerReducer.SLLB)));
        newValue = Float.valueOf(newValue.floatValue() / (Float.parseFloat(fullCurrentSoil.get(LayerReducer.SLLB)) + Float.parseFloat(previousSoil.get(LayerReducer.SLLB))));
        return newValue;
    }

    @Override
    public HashMap<String, String> computeSoil(Map<String, String> fullCurrentSoil, Map<String, String> previousSoil) {
        Float newValue = Float.valueOf(0.0f);
        HashMap<String, String> aggregatedSoil = new HashMap<String, String>();
        for (String p : this.allParams) {
            if (LayerReducer.SLLB.equals(p)) {
                newValue = Float.valueOf(Float.parseFloat(fullCurrentSoil.get(p)) + Float.parseFloat(previousSoil.get(p)));
            } else if (ICNH4.equals(p) && fullCurrentSoil.containsKey(ICNH4) && previousSoil.containsKey(ICNH4) || ICNO3.equals(p) && fullCurrentSoil.containsKey(ICNO3) && previousSoil.containsKey(ICNO3)) {
                newValue = this.computeInitialConditions(p, fullCurrentSoil, previousSoil);
            } else {
                String fullCurrentValue = fullCurrentSoil.get(p) == null ? LayerReducerUtil.defaultValue(p) : fullCurrentSoil.get(p);
                String previousValue = previousSoil.get(p) == null ? LayerReducerUtil.defaultValue(p) : previousSoil.get(p);
                newValue = Float.valueOf((Float.parseFloat(fullCurrentValue) + Float.parseFloat(previousValue)) / 2.0f);
            }
            aggregatedSoil.put(p, newValue.toString());
        }
        return aggregatedSoil;
    }

    @Override
    public boolean shouldAggregateSoils(HashMap<String, String> currentSoil, HashMap<String, String> previousSoil) {
        return this.criteria.shouldAggregateSoils(currentSoil, previousSoil);
    }
}

