/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.translators.soil;

import java.util.ArrayList;
import java.util.HashMap;
import org.agmip.translators.soil.LayerReducerDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerReducer {
    private static final Logger log = LoggerFactory.getLogger(LayerReducer.class);
    private LayerReducerDecorator decorator;
    private int maxSoilLayers;
    private int MAX_SOIL_LAYERS = 5;
    public static String SLLL = "slll";
    public static String SLDUL = "sldul";
    public static String SLBDM = "slbdm";
    public static String SKSAT = "sksat";
    public static String SLLB = "sllb";
    public static String SLOC = "sloc";

    public LayerReducer(LayerReducerDecorator decorator) {
        this.decorator = decorator;
        this.maxSoilLayers = this.MAX_SOIL_LAYERS;
    }

    public ArrayList<HashMap<String, String>> process(ArrayList<HashMap<String, String>> soilsData) {
        HashMap<String, String> previousSoil = null;
        boolean aggregate = true;
        boolean enforceAggregation = false;
        ArrayList<HashMap<String, String>> aggregatedSoilsData = new ArrayList<HashMap<String, String>>();
        ArrayList<HashMap<String, String>> normalizedSoilsData = this.normalizeSoilLayers(soilsData);
        log.debug("Formated soil data : " + normalizedSoilsData);
        int i = 0;
        for (HashMap<String, String> currentSoil : normalizedSoilsData) {
            ++i;
            if (previousSoil != null) {
                if (aggregatedSoilsData.size() == this.getMaxSoilLayers()) {
                    enforceAggregation = true;
                }
                boolean bl = aggregate = this.decorator.shouldAggregateSoils(currentSoil, previousSoil) || enforceAggregation;
                if (aggregate) {
                    log.debug("Aggregating soil layers... " + i + " and " + (i - 1));
                    log.debug("soil " + i + " " + currentSoil);
                    log.debug("soil " + (i - 1) + " " + previousSoil);
                    HashMap<String, String> aggregatedSoil = this.decorator.computeSoil(currentSoil, previousSoil);
                    if (aggregatedSoilsData.contains(previousSoil)) {
                        aggregatedSoilsData.remove(previousSoil);
                    }
                    previousSoil = aggregatedSoil;
                    aggregatedSoilsData.add(aggregatedSoil);
                    continue;
                }
                previousSoil = currentSoil;
                log.debug("Adding soil layer ...");
                log.debug("soil " + i + " " + currentSoil);
                aggregatedSoilsData.add(currentSoil);
                continue;
            }
            previousSoil = currentSoil;
            aggregatedSoilsData.add(currentSoil);
        }
        log.debug("Information about soil aggregation");
        log.debug("Soil layers before : " + soilsData.size());
        log.debug("Soil layers after  : " + aggregatedSoilsData.size());
        return aggregatedSoilsData;
    }

    public int getMaxSoilLayers() {
        return this.maxSoilLayers;
    }

    public void setMaxSoilLayers(int maxSoilLayers) {
        this.maxSoilLayers = maxSoilLayers;
    }

    public ArrayList<HashMap<String, String>> normalizeSoilLayers(ArrayList<HashMap<String, String>> soilsData) {
        HashMap<String, String> referenceSoil = soilsData.get(0);
        ArrayList<HashMap<String, String>> newSoilsData = new ArrayList<HashMap<String, String>>();
        if (referenceSoil != null) {
            for (HashMap<String, String> currentSoil : soilsData) {
                HashMap<String, String> fullCurrentSoil = new HashMap<String, String>(referenceSoil);
                for (String key : referenceSoil.keySet()) {
                    if (!currentSoil.containsKey(key)) continue;
                    fullCurrentSoil.put(key, currentSoil.get(key));
                }
                newSoilsData.add(fullCurrentSoil);
            }
        }
        return newSoilsData;
    }
}

