/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.functions;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.agmip.common.Functions;
import org.agmip.util.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeatherHelper {
    private static final Logger LOG = LoggerFactory.getLogger(WeatherHelper.class);

    public static HashMap<String, String> getTavAndAmp(HashMap data) {
        MonthlyAvg tmonth;
        HashMap<String, String> results = new HashMap<String, String>();
        HashMap<Integer, MonthlyAvg> tyear = new HashMap<Integer, MonthlyAvg>();
        ArrayList dailyArr = WeatherHelper.getDailyData(data);
        for (int i = 0; i < dailyArr.size(); ++i) {
            HashMap dailyData = (HashMap)dailyArr.get(i);
            String date = MapUtil.getValueOr((Map)dailyData, (String)"w_date", (String)"").trim();
            if (date.equals("")) {
                LOG.warn("There is daily data do not having a valid date");
                continue;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(Functions.convertFromAgmipDateString(date));
            int year = cal.get(1);
            int month = cal.get(2);
            tmonth = (MonthlyAvg)tyear.get(year);
            if (tmonth == null) {
                tmonth = new MonthlyAvg();
                tyear.put(year, tmonth);
            }
            String tmax = MapUtil.getValueOr((Map)dailyData, (String)"tmax", (String)"").trim();
            String tmin = MapUtil.getValueOr((Map)dailyData, (String)"tmin", (String)"").trim();
            String tavgDaily = Functions.average(tmax, tmin);
            if (tavgDaily == null) continue;
            tmonth.add(month, tavgDaily);
        }
        MonthlyAvg tavAllYears = new MonthlyAvg();
        ArrayList<String> tampAllYears = new ArrayList<String>();
        Iterator it = tyear.keySet().iterator();
        while (it.hasNext()) {
            int year = (Integer)it.next();
            tmonth = (MonthlyAvg)tyear.get(year);
            String[] tavgs = tmonth.getAllAvg();
            for (int month = 0; month < tavgs.length; ++month) {
                tavAllYears.add(month, tavgs[month]);
            }
            String tampt = Functions.substract(Functions.max(tavgs), Functions.min(tavgs));
            if (tampt == null) continue;
            tampAllYears.add(tampt);
        }
        String tav = Functions.average(2, Functions.removeNull(tavAllYears.getAllAvg()));
        String tamp = Functions.average(2, tampAllYears.toArray(new String[0]));
        if (tav != null) {
            results.put("tav", tav);
        }
        if (tamp != null) {
            results.put("tamp", tamp);
        }
        return results;
    }

    protected static ArrayList getDailyData(HashMap data) {
        if (data.containsKey("weather") || !data.containsKey("dailyWeather")) {
            return MapUtil.getBucket((Map)data, (String)"weather").getDataList();
        }
        return new MapUtil.BucketEntry(data).getDataList();
    }

    protected static HashMap getWthData(HashMap data) {
        if (data.containsKey("weather")) {
            return (HashMap)MapUtil.getObjectOr((Map)data, (Object)"weather", new HashMap());
        }
        return data;
    }

    public static HashMap<String, ArrayList<String>> getEto(HashMap data) {
        HashMap<String, ArrayList<String>> results = new HashMap<String, ArrayList<String>>();
        HashMap wthData = WeatherHelper.getWthData(data);
        ArrayList dailyArr = WeatherHelper.getDailyData(data);
        String wst_elev = MapUtil.getValueOr((Map)wthData, (String)"wst_elev", (String)"");
        if (wst_elev.equals("")) {
            return results;
        }
        String P = Functions.multiply("101.3", Functions.pow(Functions.divide(Functions.substract("293", Functions.product("0.0065", wst_elev)), "293"), "5.26"));
        String gamma = Functions.product("0.664742", "0.001", P);
        String wst_lat = MapUtil.getValueOr((Map)wthData, (String)"wst_lat", (String)"");
        String phi = Functions.divide(Functions.product(wst_lat, "3.141592653589793"), "180");
        String psyvnt = MapUtil.getValueOr((Map)wthData, (String)"psyvnt", (String)"").trim();
        String aPsy = "";
        if (psyvnt.equals("Forced")) {
            aPsy = "0.000662";
        } else if (psyvnt.equals("Natural")) {
            aPsy = "0.00800";
        }
        String rPsy = Functions.multiply(aPsy, P);
        String amth = MapUtil.getValueOr((Map)wthData, (String)"amth", (String)"0.25");
        String bmth = MapUtil.getValueOr((Map)wthData, (String)"bmth", (String)"0.50");
        ArrayList<String> etoArr = new ArrayList<String>();
        for (int i = 0; i < dailyArr.size(); ++i) {
            String u2;
            String alt2;
            String ea;
            HashMap dailyData = (HashMap)dailyArr.get(i);
            String tMin = MapUtil.getValueOr((Map)dailyData, (String)"tmin", (String)"").trim();
            String tMax = MapUtil.getValueOr((Map)dailyData, (String)"tmax", (String)"").trim();
            if (tMin.equals("") || tMax.equals("")) {
                etoArr.add(null);
                continue;
            }
            String tMean = Functions.average(tMin, tMax);
            String e_tMax = Functions.multiply("0.6108", Functions.exp(Functions.divide(Functions.multiply("17.27", tMax), Functions.sum(tMax, "237.3"))));
            String e_tMin = Functions.multiply("0.6108", Functions.exp(Functions.divide(Functions.multiply("17.27", tMin), Functions.sum(tMin, "237.3"))));
            String es = Functions.average(e_tMax, e_tMin);
            String slope = Functions.divide(Functions.product("4098", "0.6108", Functions.exp(Functions.divide(Functions.multiply("17.27", tMean), Functions.sum(tMean, "237.3")))), Functions.pow(Functions.sum(tMean, "237.3"), "2"));
            String alt1 = MapUtil.getValueOr((Map)dailyData, (String)"vprsd", (String)"").trim();
            if (!alt1.equals("")) {
                ea = alt1;
            } else {
                alt1 = MapUtil.getValueOr((Map)dailyData, (String)"tdew", (String)"").trim();
                if (!alt1.equals("")) {
                    ea = Functions.multiply("0.6108", Functions.exp(Functions.divide(Functions.multiply("17.27", alt1), Functions.sum(alt1, "237.3"))));
                } else {
                    alt1 = MapUtil.getValueOr((Map)dailyData, (String)"rhmxd", (String)"").trim();
                    if (!alt1.equals("") && !(alt2 = MapUtil.getValueOr((Map)dailyData, (String)"rhmnd", (String)MapUtil.getValueOr((Map)dailyData, (String)"rhumd", (String)"")).trim()).equals("")) {
                        ea = Functions.average(Functions.product(e_tMin, alt1, "0.01"), Functions.product(e_tMax, alt2, "0.01"));
                    } else {
                        alt1 = MapUtil.getValueOr((Map)dailyData, (String)"tdry", (String)"").trim();
                        if (!alt1.equals("") && !(alt2 = MapUtil.getValueOr((Map)dailyData, (String)"twet", (String)"").trim()).equals("") && rPsy != null) {
                            String e_tWet = Functions.multiply("0.6108", Functions.exp(Functions.divide(Functions.multiply("17.27", alt2), Functions.sum(alt2, "237.3"))));
                            ea = Functions.substract(e_tWet, Functions.multiply(rPsy, Functions.substract(alt1, alt2)));
                        } else {
                            ea = e_tMin;
                        }
                    }
                }
            }
            String vpDiff = Functions.substract(es, ea);
            Date w_date = Functions.convertFromAgmipDateString(MapUtil.getValueOr((Map)dailyData, (String)"w_date", (String)""));
            if (w_date == null) {
                etoArr.add(null);
                continue;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(w_date);
            String J = cal.get(6) + "";
            String dr = Functions.sum("1", Functions.multiply("0.033", Functions.cos(Functions.product("2", Functions.divide("3.141592653589793", "365"), J))));
            String delta = Functions.multiply("0.409", Functions.sin(Functions.substract(Functions.product("2", Functions.divide("3.141592653589793", "365"), J), "1.39")));
            String omegas = Functions.acos(Functions.product("-1", Functions.tan(phi), Functions.tan(delta)));
            String ra = Functions.divide(Functions.product("1440", "0.0820", dr, Functions.sum(Functions.product(omegas, Functions.sin(phi), Functions.sin(delta)), Functions.product(Functions.cos(phi), Functions.cos(delta), Functions.sin(omegas)))), "3.141592653589793");
            String N = Functions.divide(Functions.multiply("24", omegas), "3.141592653589793");
            alt1 = MapUtil.getValueOr((Map)dailyData, (String)"srad", (String)"").trim();
            String rs = !alt1.equals("") ? alt1 : (!(alt1 = MapUtil.getValueOr((Map)dailyData, (String)"sunh", (String)"").trim()).equals("") ? Functions.multiply(Functions.sum(amth, Functions.divide(Functions.multiply(bmth, alt1), N)), ra) : Functions.product(WeatherHelper.getKrsValue(wthData), Functions.sqrt(Functions.substract(tMax, tMin)), ra));
            String rso = Functions.multiply(Functions.sum("0.75", Functions.product("2e-5", wst_elev)), ra);
            String rns = Functions.multiply(Functions.substract("1", "0.23"), rs);
            String rnl = Functions.product("4.903e-9", Functions.average(Functions.pow(Functions.sum(tMax, "273.16"), "4"), Functions.pow(Functions.sum(tMin, "273.16"), "4")), Functions.substract("0.34", Functions.multiply("0.14", Functions.sqrt(ea))), Functions.substract(Functions.divide(Functions.multiply("1.35", rs), rso), "0.35"));
            String rn = Functions.substract(rns, rnl);
            alt1 = MapUtil.getValueOr((Map)dailyData, (String)"wind", (String)"").trim();
            if (!alt1.equals("")) {
                String uz = Functions.divide(Functions.multiply("1000", alt1), "86400", 4);
                alt2 = MapUtil.getValueOr((Map)wthData, (String)"wndht", (String)"").trim();
                u2 = Functions.compare(alt2, "2", Functions.CompareMode.EQUAL) ? uz : Functions.divide(Functions.multiply(uz, "4.87"), Functions.log(Functions.substract(Functions.multiply("67.8", alt2), "5.42")));
            } else {
                u2 = "2";
            }
            String eto = Functions.divide(Functions.sum(Functions.product("0.408", slope, rn), Functions.divide(Functions.product(gamma, "900", u2, vpDiff), Functions.sum(tMean, "273"))), Functions.sum(slope, Functions.multiply(gamma, Functions.sum("1", Functions.multiply("0.34", u2)))));
            etoArr.add(Functions.round(eto, 2));
        }
        results.put("eto", etoArr);
        return results;
    }

    private static String getKrsValue(HashMap data) {
        return "0.16";
    }

    private static class MonthlyAvg {
        private int[] days = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        private String[] avg = new String[12];

        private MonthlyAvg() {
        }

        public void add(int month, String val) {
            if (val == null) {
                return;
            }
            if (this.avg[month] == null) {
                this.avg[month] = val;
                this.days[month] = 1;
            } else {
                this.avg[month] = Functions.sum(this.avg[month], val);
                int n = month;
                this.days[n] = this.days[n] + 1;
            }
        }

        public String getAvg(int month) {
            if (this.days[month] <= 0) {
                return null;
            }
            return Functions.divide(this.avg[month], this.days[month] + "");
        }

        public String[] getAllAvg() {
            String[] ret = new String[this.days.length];
            for (int i = 0; i < this.days.length; ++i) {
                ret[i] = this.getAvg(i);
            }
            return ret;
        }
    }
}

