/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.functions;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.agmip.common.Functions;
import org.agmip.functions.ExperimentHelper;
import org.agmip.util.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoilHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SoilHelper.class);

    public static HashMap<String, ArrayList<String>> getRootDistribution(HashMap data, String var, String m, String pp, String rd) {
        int i;
        String k;
        String[] sllbs;
        HashMap<String, ArrayList<String>> results = new HashMap<String, ArrayList<String>>();
        ArrayList<String> result = new ArrayList<String>();
        ArrayList soilLayers = SoilHelper.getSoilLayer(data);
        if (soilLayers == null) {
            return results;
        }
        if (soilLayers.isEmpty()) {
            LOG.error("----  SOIL LAYER DATA IS EMPTY");
            return results;
        }
        try {
            sllbs = new String[soilLayers.size()];
            k = Functions.divide(Math.log(0.02) + "", Functions.substract(rd, pp));
            for (i = 0; i < soilLayers.size(); ++i) {
                sllbs[i] = (String)((HashMap)soilLayers.get(i)).get("sllb");
            }
        }
        catch (NumberFormatException e) {
            LOG.error("INVALID INPUT NUMBER [" + e.getMessage() + "]");
            return results;
        }
        result.add(Functions.round(SoilHelper.getGrowthFactor(Functions.divide(sllbs[0], "2"), pp, k, m), 3));
        for (i = 1; i < sllbs.length; ++i) {
            result.add(Functions.round(SoilHelper.getGrowthFactor(Functions.average(sllbs[i], sllbs[i - 1]), pp, k, m), 3));
        }
        results.put(var, result);
        return results;
    }

    public static HashMap<String, ArrayList<String>> getIcnDistribution(HashMap data, String icin) {
        HashMap<String, ArrayList<String>> results = new HashMap<String, ArrayList<String>>();
        ArrayList soilLayers = SoilHelper.getSoilLayer(data);
        if ((icin = Functions.sum(icin)) == null) {
            LOG.error("Input variable ICIN come with invalid  value icin={}", (Object)icin);
            return results;
        }
        String lastSllb = "0";
        String[] productSBXTH = new String[soilLayers.size()];
        for (int i = 0; i < soilLayers.size(); ++i) {
            HashMap soilLayer = (HashMap)soilLayers.get(i);
            String sllb = MapUtil.getValueOr((Map)soilLayer, (String)"sllb", (String)"");
            String slbdm = MapUtil.getValueOr((Map)soilLayer, (String)"slbdm", (String)"");
            String thick = Functions.substract(sllb, lastSllb);
            productSBXTH[i] = Functions.product(slbdm, thick);
            if (productSBXTH[i] == null) {
                LOG.error("Invalid SLLB and/or SLBDM in the soil layer data with value sllb={}, slbdm={}", (Object)sllb, (Object)slbdm);
                return results;
            }
            lastSllb = sllb;
        }
        String totalSBXTH = Functions.sum(productSBXTH);
        if (Functions.compare(totalSBXTH, "0", Functions.CompareMode.EQUAL)) {
            LOG.error("Total SLBDM * thick is 0");
            return results;
        }
        String nppm = Functions.divide(Functions.product(icin, "10"), totalSBXTH);
        String icnh4 = Functions.product("0.1", nppm);
        String icno3 = Functions.product("0.9", nppm);
        ArrayList<String> icnTotArr = new ArrayList<String>();
        ArrayList<String> icnh4Arr = new ArrayList<String>();
        ArrayList<String> icno3Arr = new ArrayList<String>();
        for (int i = 0; i < productSBXTH.length; ++i) {
            String icn_tot = Functions.divide(Functions.product(productSBXTH[i], icin), totalSBXTH);
            icnTotArr.add(Functions.round(icn_tot, 2));
            icnh4Arr.add(Functions.round(icnh4, 2));
            icno3Arr.add(Functions.round(icno3, 2));
        }
        results.put("icn_tot", icnTotArr);
        results.put("icnh4", icnh4Arr);
        results.put("icno3", icno3Arr);
        return results;
    }

    protected static String getGrowthFactor(String mid, String pp, String k, String m) {
        if (Functions.compare(mid, pp, Functions.CompareMode.NOTGREATER)) {
            return m;
        }
        return Functions.multiply(m, Functions.exp(Functions.multiply(k, Functions.substract(mid, pp))));
    }

    protected static ArrayList getSoilLayer(HashMap data) {
        if (data.containsKey("soil") || !data.containsKey("soilLayer")) {
            return MapUtil.getBucket((Map)data, (String)"soil").getDataList();
        }
        return new MapUtil.BucketEntry(data).getDataList();
    }

    public static ArrayList<HashMap<String, String>> splittingSoillayer(HashMap data, boolean isICLayer) {
        if (isICLayer) {
            return SoilHelper.splittingLayers(ExperimentHelper.getICLayer(data), "icbl");
        }
        return SoilHelper.splittingLayers(SoilHelper.getSoilLayer(data), "sllb");
    }

    private static ArrayList<HashMap<String, String>> splittingLayers(ArrayList<HashMap<String, String>> soilLayers, String depthVal) {
        String thickness;
        String curDepth;
        int i;
        ArrayList<HashMap<String, String>> ret = new ArrayList<HashMap<String, String>>();
        String lastDepth = "0";
        HashMap<Object, Object> layer = new HashMap();
        int idx = 0;
        String[] fixedTopLayerDeps = new String[]{"5", "15"};
        String[] fixedTopLayerThks = new String[]{"5.00", "10.00"};
        for (i = 0; i < fixedTopLayerDeps.length && idx < soilLayers.size(); ++i) {
            int start = idx;
            ArrayList<String> weights = new ArrayList<String>();
            while (idx < soilLayers.size()) {
                layer = soilLayers.get(idx);
                curDepth = MapUtil.getValueOr(layer, (String)depthVal, (String)"");
                if (Functions.compare(curDepth, fixedTopLayerDeps[i], Functions.CompareMode.NOTLESS)) {
                    thickness = Functions.substract(fixedTopLayerDeps[i], lastDepth);
                    weights.add(Functions.divide(thickness, fixedTopLayerThks[i]));
                    lastDepth = fixedTopLayerDeps[i];
                    if (!Functions.compare(curDepth, fixedTopLayerDeps[i], Functions.CompareMode.EQUAL)) break;
                    ++idx;
                    break;
                }
                thickness = Functions.substract(curDepth, lastDepth);
                weights.add(Functions.divide(thickness, fixedTopLayerThks[i]));
                lastDepth = curDepth;
                ++idx;
            }
            if (Functions.compare(lastDepth, fixedTopLayerDeps[i], Functions.CompareMode.LESS)) {
                LOG.warn("The soil layer is deep enough for LYRSET() function!");
                continue;
            }
            HashMap<Object, Object> newLayer = new HashMap<Object, Object>();
            if (weights.size() == 1 && ((String)weights.get(0)).equals("1")) {
                newLayer.putAll(layer);
            } else {
                HashSet<Object> vars = new HashSet<Object>();
                vars.addAll(layer.keySet());
                vars.remove(depthVal);
                for (String string : vars) {
                    String val = "0";
                    int j = 0;
                    while (j < weights.size() && (val = Functions.sum(val, Functions.product((String)(layer = soilLayers.get(start)).get(string), (String)weights.get(j)))) != null) {
                        ++j;
                        ++start;
                    }
                    if (val == null || val.equals("")) continue;
                    newLayer.put(string, val);
                }
            }
            newLayer.put(depthVal, fixedTopLayerDeps[i]);
            ret.add(newLayer);
        }
        for (i = idx; i < soilLayers.size(); ++i) {
            layer = soilLayers.get(i);
            curDepth = MapUtil.getValueOr(layer, (String)depthVal, (String)"");
            thickness = Functions.substract(curDepth, lastDepth);
            String pt = Functions.compare(curDepth, "60", Functions.CompareMode.NOTGREATER) ? "15" : (Functions.compare(curDepth, "200", Functions.CompareMode.NOTGREATER) ? "30" : "60");
            ret.addAll(SoilHelper.createNewLayers(layer, pt, thickness, lastDepth, depthVal));
            ret.add(layer);
            lastDepth = curDepth;
        }
        return ret;
    }

    private static ArrayList<HashMap<String, String>> createNewLayers(HashMap layer, String pt, String thickness, String lastDepth, String depthVal) {
        ArrayList<HashMap<String, String>> ret = new ArrayList<HashMap<String, String>>();
        if (Functions.compare(thickness, pt, Functions.CompareMode.NOTGREATER)) {
            return ret;
        }
        int newLayerNum = Functions.numericStringToBigInteger(Functions.divide(thickness, pt, 0)).intValue();
        if (Functions.compare(thickness, Functions.multiply(pt, newLayerNum + ""), Functions.CompareMode.GREATER)) {
            ++newLayerNum;
        }
        String increase = Functions.divide(thickness, newLayerNum + "", 0);
        for (int i = 0; i < newLayerNum - 1; ++i) {
            lastDepth = Functions.sum(lastDepth, increase);
            HashMap<String, String> newLayer = new HashMap<String, String>();
            newLayer.putAll(layer);
            newLayer.put(depthVal, lastDepth);
            ret.add(newLayer);
        }
        return ret;
    }

    public static HashMap<String, ArrayList<String>> getSoilValsFromOthPara(HashMap data, String calcMethod, ArrayList<String> calcVars) {
        HashMap<String, ArrayList<String>> rets = new HashMap<String, ArrayList<String>>();
        if (calcMethod.equalsIgnoreCase("PTSaxton2006")) {
            calcMethod = "PTSaxton2006";
        }
        try {
            String var;
            String packageName = SoilHelper.class.getPackage().getName();
            Class<?> calClass = Class.forName(packageName + "." + calcMethod);
            ArrayList<Method> calcMtds = new ArrayList<Method>();
            ArrayList<String> calcVarsFinal = new ArrayList<String>();
            if (calcVars.contains("all")) {
                for (Method mtd : calClass.getDeclaredMethods()) {
                    String mtdName = mtd.getName();
                    if (!mtdName.startsWith("get")) continue;
                    calcMtds.add(mtd);
                    var = mtdName.substring(3).toLowerCase();
                    calcVarsFinal.add(var);
                    rets.put(var, new ArrayList());
                }
            } else {
                for (String var2 : calcVars) {
                    try {
                        if (!rets.containsKey(var2)) {
                            calcMtds.add(calClass.getDeclaredMethod("get" + var2.toUpperCase(), String[].class));
                            calcVarsFinal.add(var2.toLowerCase());
                            rets.put(var2, new ArrayList());
                            continue;
                        }
                        LOG.warn("Variable {} is repeated in the target variable list.", (Object)var2);
                    }
                    catch (NoSuchMethodException e) {
                        LOG.error("PT Calculation for {} is not valiable in {} method", (Object)var2, (Object)calcMethod);
                    }
                }
            }
            ArrayList layers = SoilHelper.getSoilLayer(data);
            for (HashMap layer : layers) {
                String[] vals = new String[]{};
                if (calcMethod.equals("PTSaxton2006")) {
                    String sand = MapUtil.getValueOr((Map)layer, (String)"slsnd", (String)"");
                    String clay = MapUtil.getValueOr((Map)layer, (String)"slcly", (String)"");
                    String om = Functions.product(MapUtil.getValueOr((Map)layer, (String)"sloc", (String)""), "1.72");
                    String grave = MapUtil.getValueOr((Map)layer, (String)"slcf", (String)"0");
                    if ("".equals(sand)) {
                        sand = Functions.substract("100", clay, MapUtil.getValueOr((Map)layer, (String)"slsil", (String)""));
                    }
                    if (om == null || sand == null || clay.equals("")) {
                        LOG.warn("Invilid soil texture and organic matter data, PT calculation will skip this soil layer");
                        continue;
                    }
                    vals = new String[]{sand, clay, om, grave};
                }
                for (int i = 0; i < calcVarsFinal.size(); ++i) {
                    var = (String)calcVarsFinal.get(i);
                    try {
                        String val = (String)((Method)calcMtds.get(i)).invoke(calClass, new Object[]{vals});
                        rets.get(var).add(val);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error(Functions.getStackTrace(e));
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("{} is not a valid name for PT calculation method", (Object)calcMethod);
            return rets;
        }
        return rets;
    }
}

