/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.functions;

import org.agmip.common.Functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTSaxton2006 {
    private static final Logger LOG = LoggerFactory.getLogger(PTSaxton2006.class);
    private static final String CONST_LN1500_LN33 = Functions.substract(Functions.log("1500"), Functions.log("33"));

    public static String getSLLL(String[] soilParas) {
        if (soilParas != null && soilParas.length >= 3) {
            return Functions.divide(PTSaxton2006.calcMoisture1500Kpa(soilParas[0], soilParas[1], soilParas[2]), "100", 3);
        }
        return null;
    }

    public static String getSLDUL(String[] soilParas) {
        if (soilParas != null && soilParas.length >= 3) {
            return Functions.divide(PTSaxton2006.calcMoisture33Kpa(soilParas[0], soilParas[1], soilParas[2]), "100", 3);
        }
        return null;
    }

    public static String getSLSAT(String[] soilParas) {
        if (soilParas != null && soilParas.length >= 3) {
            return Functions.divide(PTSaxton2006.calcSaturatedMoisture(soilParas[0], soilParas[1], soilParas[2]), "100", 3);
        }
        return null;
    }

    public static String getSKSAT(String[] soilParas) {
        if (soilParas != null && soilParas.length >= 3) {
            if (soilParas.length >= 4) {
                return Functions.divide(PTSaxton2006.calcSatBulk(soilParas[0], soilParas[1], soilParas[2], Functions.divide(soilParas[3], "100")), "10", 3);
            }
            return Functions.divide(PTSaxton2006.calcSatMatric(soilParas[0], soilParas[1], soilParas[2]), "10", 3);
        }
        return null;
    }

    public static String getSLBDM(String[] soilParas) {
        if (soilParas != null && soilParas.length >= 3) {
            if (soilParas.length >= 4) {
                return Functions.round(PTSaxton2006.calcGravePlusDensity(soilParas[0], soilParas[1], soilParas[2], Functions.divide(soilParas[3], "100")), 2);
            }
            return Functions.round(PTSaxton2006.calcNormalDensity(soilParas[0], soilParas[1], soilParas[2]), 2);
        }
        return null;
    }

    public static String calcMoisture1500Kpa(String slsnd, String slcly, String omPct) {
        if ((slsnd = Functions.checkPctVal(slsnd)) == null || (slcly = Functions.checkPctVal(slcly)) == null || (omPct = Functions.checkPctVal(omPct)) == null) {
            LOG.error("Invalid input parameters for calculating 1500 kPa moisture, %v");
            return null;
        }
        String ret = Functions.sum(Functions.product("-0.02736", slsnd), Functions.product("0.55518", slcly), Functions.product("0.684", omPct), Functions.product("0.0057", slsnd, omPct), Functions.product("-0.01482", slcly, omPct), Functions.product("0.0007752", slsnd, slcly), "1.534");
        LOG.debug("Calculate result for 1500 kPa moisture, %v is {}", (Object)ret);
        return ret;
    }

    public static String calcMoisture33Kpa(String slsnd, String slcly, String omPct) {
        if ((slsnd = Functions.checkPctVal(slsnd)) == null || (slcly = Functions.checkPctVal(slcly)) == null || (omPct = Functions.checkPctVal(omPct)) == null) {
            LOG.error("Invalid input parameters for calculating 33 kPa moisture, normal density, %v");
            return null;
        }
        String mt33Fst = PTSaxton2006.calcMoisture33KpaFst(slsnd, slcly, omPct);
        String ret = Functions.sum(Functions.product(Functions.pow(mt33Fst, "2"), "0.01283"), Functions.product(mt33Fst, "0.626"), "-1.5");
        LOG.debug("Calculate result for 33 kPa moisture, normal density, %v is {}", (Object)ret);
        return ret;
    }

    private static String calcMoisture33KpaFst(String slsnd, String slcly, String omPct) {
        String ret = Functions.sum(Functions.product("-0.251", slsnd), Functions.product("0.195", slcly), Functions.product("1.1", omPct), Functions.product("0.006", slsnd, omPct), Functions.product("-0.027", slcly, omPct), Functions.product("0.00452", slsnd, slcly), "29.9");
        LOG.debug("Calculate result for 33 kPa moisture, first solution, %v is {}", (Object)ret);
        return ret;
    }

    public static String calcMoistureSAT33Kpa(String slsnd, String slcly, String omPct) {
        if ((slsnd = Functions.checkPctVal(slsnd)) == null || (slcly = Functions.checkPctVal(slcly)) == null || (omPct = Functions.checkPctVal(omPct)) == null) {
            LOG.error("Invalid input parameters for calculating 33 kPa moisture, normal density, %v");
            return null;
        }
        String ret = Functions.sum(Functions.product("0.45481", slsnd), Functions.product("0.055624", slcly), Functions.product("3.5992", omPct), Functions.product("-0.029448", slsnd, omPct), Functions.product("-0.044172", slcly, omPct), Functions.product("-0.00955424", slsnd, slcly), "2.0608");
        LOG.debug("Calculate result for 33 kPa moisture, normal density, %v is {}", (Object)ret);
        return ret;
    }

    public static String calcSaturatedMoisture(String slsnd, String slcly, String omPct) {
        String mt33 = PTSaxton2006.calcMoisture33Kpa(slsnd, slcly, omPct);
        String mtSAT33 = PTSaxton2006.calcMoistureSAT33Kpa(slsnd, slcly, omPct);
        String ret = Functions.sum(mt33, mtSAT33, Functions.product(slsnd, "-0.097"), "4.3");
        LOG.debug("Calculate result for Saturated moisture (0 kPa), normal density, %v is {}", (Object)ret);
        return ret;
    }

    public static String calcNormalDensity(String slsnd, String slcly, String omPct) {
        String satMt = PTSaxton2006.calcSaturatedMoisture(slsnd, slcly, omPct);
        String ret = Functions.product(Functions.substract("100", satMt), "0.0265");
        LOG.debug("Calculate result for Normal density, g/cm-3 is {}", (Object)ret);
        return ret;
    }

    public static String calcAdjustedDensity(String slsnd, String slcly, String omPct, String df) {
        if (Functions.compare(df, "0.9", Functions.CompareMode.NOTLESS) && Functions.compare(df, "1.3", Functions.CompareMode.NOTGREATER)) {
            String normalDensity = PTSaxton2006.calcNormalDensity(slsnd, slcly, omPct);
            String ret = Functions.product(normalDensity, df);
            LOG.debug("Calculate result for Adjusted density, g/cm-3 is {}", (Object)ret);
            return ret;
        }
        LOG.error("Density adjustment Factor is out of range (0.9 - 1.3) : {}", (Object)df);
        return null;
    }

    public static String calcAdjustedSaturatedMoisture(String slsnd, String slcly, String omPct, String df) {
        String adjDensity = PTSaxton2006.calcAdjustedDensity(slsnd, slcly, omPct, df);
        String ret = Functions.substract("100", Functions.divide(adjDensity, "0.0265"));
        LOG.debug("Calculate result for Saturated moisture (0 kPa), adjusted density, ([0,100]%) is {}", (Object)ret);
        return ret;
    }

    public static String calcAdjustedMoisture33Kpa(String slsnd, String slcly, String omPct, String df) {
        String mt33 = PTSaxton2006.calcMoisture33Kpa(slsnd, slcly, omPct);
        String satMt = PTSaxton2006.calcSaturatedMoisture(slsnd, slcly, omPct);
        String adjSatMt = PTSaxton2006.calcAdjustedSaturatedMoisture(slsnd, slcly, omPct, df);
        String ret = Functions.substract(mt33, Functions.product(Functions.substract(satMt, adjSatMt), "0.2"));
        LOG.debug("Calculate result for 33 kPa moisture, adjusted density, ([0,100]%) is {}", (Object)ret);
        return ret;
    }

    public static String calcAdjustedMoistureSAT33Kpa(String slsnd, String slcly, String omPct, String df) {
        String adjSatMt = PTSaxton2006.calcAdjustedSaturatedMoisture(slsnd, slcly, omPct, df);
        String adjMt33 = PTSaxton2006.calcAdjustedMoisture33Kpa(slsnd, slcly, omPct, df);
        String ret = Functions.substract(adjSatMt, adjMt33);
        LOG.debug("Calculate result for SAT-33 kPa moisture, adjusted, ([0,100]%) is {}", (Object)ret);
        return ret;
    }

    private static String calcLamda(String slsnd, String slcly, String omPct) {
        String mt33 = Functions.divide(PTSaxton2006.calcMoisture33Kpa(slsnd, slcly, omPct), "100");
        String mt1500 = Functions.divide(PTSaxton2006.calcMoisture1500Kpa(slsnd, slcly, omPct), "100");
        String ret = Functions.divide(Functions.substract(Functions.log(mt33), Functions.log(mt1500)), CONST_LN1500_LN33);
        LOG.debug("Calculate result for Slope of logarithmic tension-moisture curve is {}", (Object)ret);
        return ret;
    }

    public static String calcSatMatric(String slsnd, String slcly, String omPct) {
        String satMt = Functions.divide(PTSaxton2006.calcSaturatedMoisture(slsnd, slcly, omPct), "100");
        String mt33 = Functions.divide(PTSaxton2006.calcMoisture33Kpa(slsnd, slcly, omPct), "100");
        String lamda = PTSaxton2006.calcLamda(slsnd, slcly, omPct);
        String ret = Functions.product("1930", Functions.pow(Functions.substract(satMt, mt33), Functions.substract("3", lamda)));
        LOG.debug("Calculate result for Saturated conductivity (matric soil), mm/h is {}", (Object)ret);
        return ret;
    }

    public static String calcGravePlusDensity(String slsnd, String slcly, String omPct, String slcf) {
        String slbdm = PTSaxton2006.calcNormalDensity(slsnd, slcly, omPct);
        String alpha = Functions.divide(slbdm, "2.65");
        String slcfv = Functions.divide(Functions.product(alpha, slcf), Functions.substract("1", slcf, Functions.product("-1", slcf, alpha)));
        String ret = Functions.sum(Functions.product(slbdm, Functions.substract("1", slcfv)), Functions.product(slcfv, "2.65"));
        LOG.debug("Calculate result for Bulk soil density (matric plus gravel), g/cm-3 is {}", (Object)ret);
        return ret;
    }

    public static String calcSatBulk(String slsnd, String slcly, String omPct, String slcf) {
        String satMatric = PTSaxton2006.calcSatMatric(slsnd, slcly, omPct);
        String slbdm = PTSaxton2006.calcNormalDensity(slsnd, slcly, omPct);
        String alpha = Functions.divide(slbdm, "2.65");
        String ratio = Functions.divide(Functions.substract("1", slcf), Functions.substract("1", slcf, Functions.product("-1.5", slcf, alpha)));
        String ret = Functions.product(satMatric, ratio);
        LOG.debug("Calculate result for Saturated conductivity (bulk soil), mm/h is {}", (Object)ret);
        return ret;
    }
}

