/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.functions;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.agmip.common.Functions;
import org.agmip.util.JSONAdapter;
import org.agmip.util.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCombinationHelper {
    private static final String defValC = "-99";
    private static final String defValI = "-99";
    private static final String defValD = "-99";
    private static final String defValR = "-99";
    private static final String defValBlank = "";
    private static final Logger LOG = LoggerFactory.getLogger(DataCombinationHelper.class);

    public static HashMap<String, ArrayList> combine(String ... jsons) throws IOException {
        List<String> arr = Arrays.asList(jsons);
        return DataCombinationHelper.combine(arr);
    }

    public static HashMap<String, ArrayList> combine(List<String> jsons) throws IOException {
        HashMap<String, ArrayList> data = new HashMap<String, ArrayList>();
        if (jsons == null || jsons.size() < 1) {
            return data;
        }
        for (String json : jsons) {
            HashMap tmp = JSONAdapter.fromJSONFile((String)json);
            DataCombinationHelper.conbineData(data, tmp, "experiments");
            DataCombinationHelper.conbineData(data, tmp, "soils");
            DataCombinationHelper.conbineData(data, tmp, "weathers");
        }
        return data;
    }

    private static void conbineData(HashMap to, HashMap from, String dataType) {
        ArrayList fromArr = (ArrayList)from.get(dataType);
        if (fromArr != null) {
            ArrayList toArr = (ArrayList)to.get(dataType);
            if (toArr == null) {
                to.put(dataType, fromArr);
            } else {
                HashMap<String, Integer> keyId = DataCombinationHelper.getKeyId(toArr, dataType);
                String[] keys = DataCombinationHelper.getPrKeyNames(dataType);
                for (HashMap fromData : fromArr) {
                    String key = DataCombinationHelper.getPrKey(fromData, keys);
                    if (!keyId.containsKey(key)) {
                        toArr.add(fromData);
                        continue;
                    }
                    HashMap toData = (HashMap)toArr.get(keyId.get(key));
                    if (fromData.equals(toData)) continue;
                    DataCombinationHelper.combine(toData, fromData);
                }
                toArr.addAll(fromArr);
            }
        }
    }

    private static HashMap<String, Integer> getKeyId(ArrayList<HashMap> dataArr, String dataType) {
        String[] keys = DataCombinationHelper.getPrKeyNames(dataType);
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (int i = 0; i < dataArr.size(); ++i) {
            ret.put(DataCombinationHelper.getPrKey(dataArr.get(i), keys), i);
        }
        return ret;
    }

    private static String[] getPrKeyNames(String dataType) {
        if ("experiments".equals(dataType)) {
            return new String[]{"exname"};
        }
        if ("soils".equals(dataType)) {
            return new String[]{"soil_id"};
        }
        return new String[]{"wst_id", "clim_id"};
    }

    private static String getPrKey(HashMap data, String[] keys) {
        if (keys == null || keys.length < 1) {
            return defValBlank;
        }
        String str = MapUtil.getValueOr((Map)data, (String)keys[0], (String)(keys[0] + "-N/A"));
        for (int j = 1; j < keys.length; ++j) {
            str = str + "_" + MapUtil.getValueOr((Map)data, (String)keys[j], (String)(keys[j] + "-N/A"));
        }
        return str;
    }

    private static void combine(HashMap to, HashMap from) {
        for (Object key : from.keySet()) {
            Object toVal = to.get(key);
            Object fromVal = from.get(key);
            if (toVal == null) {
                to.put(key, fromVal);
                continue;
            }
            if (fromVal == null) continue;
            if (fromVal instanceof ArrayList && toVal instanceof ArrayList) {
                ((ArrayList)toVal).addAll((ArrayList)fromVal);
                continue;
            }
            if (fromVal instanceof HashMap && toVal instanceof HashMap) {
                DataCombinationHelper.combine((HashMap)toVal, (HashMap)fromVal);
                continue;
            }
            to.put(key, fromVal);
        }
    }

    public static void fixData(Map data) {
        ArrayList exps = (ArrayList)MapUtil.getObjectOr((Map)data, (Object)"experiments", new ArrayList());
        HashSet<String> soilIds = DataCombinationHelper.getIds((ArrayList)MapUtil.getObjectOr((Map)data, (Object)"soils", new ArrayList()), "soil_id");
        HashSet<String> wstIds = DataCombinationHelper.getIds((ArrayList)MapUtil.getObjectOr((Map)data, (Object)"weathers", new ArrayList()), "wst_id");
        for (HashMap exp : exps) {
            DataCombinationHelper.fixDataLink(exp, soilIds, "soil_id", 10);
            DataCombinationHelper.fixDataLink(exp, wstIds, "wst_id", 4);
            DataCombinationHelper.fixEventDate(exp);
            DataCombinationHelper.fixSimCtrl(exp);
            DataCombinationHelper.fixEnvMdf(exp);
        }
    }

    private static HashSet<String> getIds(ArrayList<HashMap> arr, String idName) {
        HashSet<String> ids = new HashSet<String>();
        for (HashMap data : arr) {
            String id = (String)data.get(idName);
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    private static void fixDataLink(HashMap expData, HashSet ids, String idName, int adjustLength) {
        String id = (String)expData.get(idName);
        boolean isIdFixed = false;
        if (id != null && !ids.isEmpty()) {
            while (!ids.contains(id)) {
                if (id.length() > adjustLength) {
                    id = id.substring(0, adjustLength);
                    isIdFixed = true;
                    continue;
                }
                isIdFixed = false;
                break;
            }
        }
        if (isIdFixed) {
            LOG.info("Fix {} to {} for experiment {}", new Object[]{idName, id, MapUtil.getValueOr((Map)expData, (String)"exname", (String)"N/A")});
            expData.put(idName, id);
        }
    }

    private static void fixEventDate(HashMap expData) {
        ArrayList events = MapUtil.getBucket((Map)expData, (String)"management").getDataList();
        String pdate = DataCombinationHelper.getPdate(events);
        if (pdate == null) {
            LOG.warn("Planting date is missing, will quit fixing event date");
            return;
        }
        String exname = MapUtil.getValueOr((Map)expData, (String)"exname", (String)"N/A");
        for (HashMap event : events) {
            String date = (String)event.get("date");
            if (date == null || date.length() == 8) continue;
            String newDate = Functions.dateOffset(pdate, date);
            event.put("date", newDate);
            LOG.info("Fix {} date to {} for experiment {}", new Object[]{event.get("event"), newDate, exname});
        }
    }

    private static String getPdate(ArrayList<HashMap<String, String>> events) {
        for (HashMap<String, String> event : events) {
            if (!"planting".equals(event.get("event"))) continue;
            return event.get("date");
        }
        return null;
    }

    private static void fixSimCtrl(HashMap expData) {
        HashMap smData = (HashMap)MapUtil.getObjectOr((Map)expData, (Object)"dssat_simulation_control", new HashMap());
        ArrayList smArr = (ArrayList)MapUtil.getObjectOr((Map)smData, (Object)"data", new ArrayList());
        for (HashMap data : smArr) {
            String smStr;
            HashMap smCtrls;
            if (!data.containsKey("sm_general") && !(smCtrls = (HashMap)MapUtil.getObjectOr((Map)data, (Object)"general", new HashMap())).isEmpty()) {
                smStr = String.format("%1$-11s %2$5s %3$5s %4$5s %5$5s %6$5s %7$-25s %8$s", MapUtil.getValueOr((Map)smCtrls, (String)"general", (String)"GE"), MapUtil.getValueOr((Map)smCtrls, (String)"nyers", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"nreps", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"start", (String)"-99"), DataCombinationHelper.getDate(smCtrls, "sdate", "sdyer", "sdday", "-99"), MapUtil.getValueOr((Map)smCtrls, (String)"rseed", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"sname", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"model", (String)"-99"));
                data.put("sm_general", smStr);
            }
            if (!data.containsKey("sm_options") && !(smCtrls = (HashMap)MapUtil.getObjectOr((Map)data, (Object)"options", new HashMap())).isEmpty()) {
                smStr = String.format("%1$-11s %2$5s %3$5s %4$5s %5$5s %6$5s %7$5s %8$5s %9$5s %10$5s", MapUtil.getValueOr((Map)smCtrls, (String)"options", (String)"OP"), MapUtil.getValueOr((Map)smCtrls, (String)"water", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"nitro", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"symbi", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"phosp", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"potas", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"dises", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"chem", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"till", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"co2", (String)"-99"));
                data.put("sm_options", smStr);
            }
            if (!data.containsKey("sm_methods") && !(smCtrls = (HashMap)MapUtil.getObjectOr((Map)data, (Object)"methods", new HashMap())).isEmpty()) {
                smStr = String.format("%1$-11s %2$5s %3$5s %4$5s %5$5s %6$5s %7$5s %8$5s %9$5s %10$5s %11$5s %12$5s", MapUtil.getValueOr((Map)smCtrls, (String)"methods", (String)"ME"), MapUtil.getValueOr((Map)smCtrls, (String)"wther", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"incon", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"light", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"evapo", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"infil", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"photo", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"hydro", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"nswit", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"mesom", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"mesev", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"mesol", (String)"-99"));
                data.put("sm_methods", smStr);
            }
            if (!data.containsKey("sm_management") && !(smCtrls = (HashMap)MapUtil.getObjectOr((Map)data, (Object)"management", new HashMap())).isEmpty()) {
                smStr = String.format("%1$-11s %2$5s %3$5s %4$5s %5$5s %6$5s", MapUtil.getValueOr((Map)smCtrls, (String)"management", (String)"MA"), MapUtil.getValueOr((Map)smCtrls, (String)"plant", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"irrig", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"ferti", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"resid", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"harvs", (String)"-99"));
                data.put("sm_management", smStr);
            }
            if (!data.containsKey("sm_outputs") && !(smCtrls = (HashMap)MapUtil.getObjectOr((Map)data, (Object)"outputs", new HashMap())).isEmpty()) {
                smStr = String.format("%1$-11s %2$5s %3$5s %4$5s %5$5s %6$5s %7$5s %8$5s %9$5s %10$5s %11$5s %12$5s %13$5s %14$5s", MapUtil.getValueOr((Map)smCtrls, (String)"outputs", (String)"OU"), MapUtil.getValueOr((Map)smCtrls, (String)"fname", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"ovvew", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"sumry", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"fropt", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"grout", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"caout", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"waout", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"niout", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"miout", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"diout", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"vbose", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"chout", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"opout", (String)"-99"));
                data.put("sm_outputs", smStr);
            }
            if (!data.containsKey("sm_planting") && !(smCtrls = (HashMap)MapUtil.getObjectOr((Map)data, (Object)"planting", new HashMap())).isEmpty()) {
                smStr = String.format("%1$-11s %2$5s %3$5s %4$5s %5$5s %6$5s %7$5s %8$5s", MapUtil.getValueOr((Map)smCtrls, (String)"planting", (String)"PL"), DataCombinationHelper.getDate(smCtrls, "pfrst", "pfyer", "pfday", "-99"), DataCombinationHelper.getDate(smCtrls, "plast", "plyer", "plday", "-99"), MapUtil.getValueOr((Map)smCtrls, (String)"ph2ol", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"ph2ou", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"ph2od", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"pstmx", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"pstmn", (String)"-99"));
                data.put("sm_planting", smStr);
            }
            if (!data.containsKey("sm_irrigation") && !(smCtrls = (HashMap)MapUtil.getObjectOr((Map)data, (Object)"irrigation", new HashMap())).isEmpty()) {
                smStr = String.format("%1$-11s %2$5s %3$5s %4$5s %5$-5s %6$-5s %7$5s %8$5s", MapUtil.getValueOr((Map)smCtrls, (String)"irrigation", (String)"IR"), MapUtil.getValueOr((Map)smCtrls, (String)"imdep", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"ithrl", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"ithru", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"iroff", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"imeth", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"iramt", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"ireff", (String)"-99"));
                data.put("sm_irrigation", smStr);
            }
            if (!data.containsKey("sm_nitrogen") && !(smCtrls = (HashMap)MapUtil.getObjectOr((Map)data, (Object)"nitrogen", new HashMap())).isEmpty()) {
                smStr = String.format("%1$-11s %2$5s %3$5s %4$5s %5$-5s %6$-5s", MapUtil.getValueOr((Map)smCtrls, (String)"nitrogen", (String)"NI"), MapUtil.getValueOr((Map)smCtrls, (String)"nmdep", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"nmthr", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"namnt", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"ncode", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"naoff", (String)"-99"));
                data.put("sm_nitrogen", smStr);
            }
            if (!data.containsKey("sm_residues") && !(smCtrls = (HashMap)MapUtil.getObjectOr((Map)data, (Object)"residues", new HashMap())).isEmpty()) {
                smStr = String.format("%1$-11s %2$5s %3$5s %4$5s", MapUtil.getValueOr((Map)smCtrls, (String)"residues", (String)"RE"), MapUtil.getValueOr((Map)smCtrls, (String)"ripcn", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"rtime", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"ridep", (String)"-99"));
                data.put("sm_residues", smStr);
            }
            if (data.containsKey("sm_harvests") || (smCtrls = (HashMap)MapUtil.getObjectOr((Map)data, (Object)"harvests", new HashMap())).isEmpty()) continue;
            smStr = String.format("%1$-11s %2$5s %3$5s %4$5s %5$5s", MapUtil.getValueOr((Map)smCtrls, (String)"harvests", (String)"HA"), MapUtil.getValueOr((Map)smCtrls, (String)"hfrst", (String)"-99"), DataCombinationHelper.getDate(smCtrls, "hlast", "hlyer", "hlday", "-99"), MapUtil.getValueOr((Map)smCtrls, (String)"hpcnp", (String)"-99"), MapUtil.getValueOr((Map)smCtrls, (String)"hpcnr", (String)"-99"));
            data.put("sm_harvests", smStr);
        }
    }

    private static String getDate(HashMap data, String dateId, String yearId, String dayId, String defVal) {
        String date = DataCombinationHelper.formatDateStr(MapUtil.getValueOr((Map)data, (String)dateId, (String)defVal));
        if (defVal.equals(date) && "00000".equals(date = String.format("%1$02d%2$03d", new BigDecimal(MapUtil.getValueOr((Map)data, (String)yearId, (String)"0")).intValue(), new BigDecimal(MapUtil.getValueOr((Map)data, (String)dayId, (String)"0")).intValue()))) {
            date = defVal;
        }
        return date;
    }

    protected static String formatDateStr(String startDate) {
        Calendar cal = Calendar.getInstance();
        startDate = startDate.replaceAll("/", defValBlank);
        try {
            cal.set(Integer.parseInt(startDate.substring(0, 4)), Integer.parseInt(startDate.substring(4, 6)) - 1, Integer.parseInt(startDate.substring(6)));
            return String.format("%1$02d%2$03d", cal.get(1) % 100, cal.get(6));
        }
        catch (Exception e) {
            return "-99";
        }
    }

    private static void fixEnvMdf(HashMap expData) {
        HashMap emData = (HashMap)MapUtil.getObjectOr((Map)expData, (Object)"dssat_environment_modification", new HashMap());
        ArrayList emArr = (ArrayList)MapUtil.getObjectOr((Map)emData, (Object)"data", new ArrayList());
        for (HashMap data : emArr) {
            HashMap secData;
            if (data.containsKey("em_data") || (secData = (HashMap)MapUtil.getObjectOr((Map)data, (Object)"data", new HashMap())).isEmpty()) continue;
            String emStr = String.format("%1$5s %2$5s %3$5s %4$5s %5$5s %6$5s %7$5s %8$5s %9$5s %10$s", DataCombinationHelper.getDate(secData, "date", "odyer", "odday", "-99"), MapUtil.getValueOr((Map)secData, (String)"eday", (String)defValBlank), MapUtil.getValueOr((Map)secData, (String)"erad", (String)defValBlank), MapUtil.getValueOr((Map)secData, (String)"emax", (String)defValBlank), MapUtil.getValueOr((Map)secData, (String)"emin", (String)defValBlank), MapUtil.getValueOr((Map)secData, (String)"erain", (String)defValBlank), MapUtil.getValueOr((Map)secData, (String)"eco2", (String)defValBlank), MapUtil.getValueOr((Map)secData, (String)"edew", (String)defValBlank), MapUtil.getValueOr((Map)secData, (String)"ewind", (String)defValBlank), MapUtil.getValueOr((Map)secData, (String)"em_name", (String)"-99"));
            data.put("em_data", emStr);
        }
    }
}

