/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.agmip.util.MapUtil;

public class Event {
    private int next = -1;
    private HashMap template;
    private ArrayList<HashMap<String, String>> events;
    private String eventType;

    public Event(ArrayList<HashMap<String, String>> events, String eventType) {
        this.events = events;
        this.eventType = eventType;
        this.getNextEventIndex();
        this.setTemplate();
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
        this.next = -1;
        this.getNextEventIndex();
        this.setTemplate();
    }

    public final void setTemplate() {
        this.template = new HashMap();
        if (this.isEventExist()) {
            this.template.putAll((Map)this.events.get(this.next));
        }
        this.template.put("event", this.eventType);
    }

    public void removeEvent() {
        if (this.isEventExist()) {
            this.events.remove(this.next);
            --this.next;
            this.getNextEventIndex();
        }
    }

    public void updateEvent(String key, String value) {
        this.updateEvent(key, value, true, true);
    }

    public void updateEvent(String key, String value, boolean toNext) {
        this.updateEvent(key, value, true, toNext);
    }

    public void updateEvent(String key, String value, boolean useTemp, boolean toNext) {
        if (this.isEventExist()) {
            this.getCurrentEvent().put(key, value);
        } else {
            HashMap tmp = "date".equals(key) ? this.addEvent(value, useTemp) : this.addEvent(null, useTemp);
            tmp.putAll(this.template);
            tmp.put(key, value);
        }
        if (toNext) {
            this.getNextEventIndex();
        }
    }

    public HashMap addEvent(String date, boolean useTemp) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (useTemp) {
            ret.putAll(this.template);
        } else {
            ret.put("event", this.eventType);
        }
        ret.put("date", date);
        this.getInertIndex(ret);
        this.events.add(this.next, ret);
        return ret;
    }

    private void getNextEventIndex() {
        for (int i = this.next + 1; i < this.events.size(); ++i) {
            String evName = MapUtil.getValueOr((Map)this.events.get(i), (String)"event", (String)"");
            if (!evName.equals(this.eventType)) continue;
            this.next = i;
            return;
        }
        this.next = this.events.size();
    }

    public boolean isEventExist() {
        return this.next >= 0 && this.next < this.events.size();
    }

    public HashMap getCurrentEvent() {
        if (this.isEventExist()) {
            return this.events.get(this.next);
        }
        return new HashMap();
    }

    private void getInertIndex(HashMap event) {
        int i;
        int iDate;
        try {
            iDate = Integer.parseInt(MapUtil.getValueOr((Map)event, (String)"date", (String)""));
        }
        catch (Exception e) {
            this.next = this.events.size();
            return;
        }
        int n = i = this.isEventExist() ? this.next : 0;
        while (i < this.events.size()) {
            try {
                if (iDate < Integer.parseInt(MapUtil.getValueOr((Map)this.events.get(i), (String)"date", (String)"0"))) {
                    this.next = i;
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        this.next = this.events.size();
    }
}

