/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.acmo.util;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.agmip.ace.LookupCodes;
import org.agmip.ace.util.AcePathfinderUtil;
import org.agmip.dome.DomeUtil;
import org.agmip.util.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcmoUtil {
    private static final Logger log = LoggerFactory.getLogger(AcmoUtil.class);

    private AcmoUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAcmo(String outputPath, HashMap<String, Object> datapackage, String destModel, HashMap<String, String> domeIdHashMap) {
        if (domeIdHashMap == null) {
            domeIdHashMap = new HashMap();
        }
        HashMap<String, String> wstClimMap = new HashMap<String, String>();
        HashMap<String, String> widMap = new HashMap<String, String>();
        HashMap<String, String> sidMap = new HashMap<String, String>();
        try {
            File f = new File(outputPath);
            f.mkdirs();
            String fileName = outputPath + File.separator + "ACMO_meta.dat";
            log.debug("Attempting to write {}", (Object)fileName);
            FileWriter fw = new FileWriter(fileName);
            BufferedWriter bw = new BufferedWriter(fw);
            for (HashMap wst : MapUtil.getRawPackageContents(datapackage, (String)"weathers")) {
                String wst_id = MapUtil.getValueOr((Map)wst, (String)"wst_id", (String)"");
                wstClimMap.put(wst_id, MapUtil.getValueOr((Map)wst, (String)"clim_id", (String)"0XXX"));
                widMap.put(wst_id, MapUtil.getValueOr((Map)wst, (String)"wid", (String)""));
            }
            for (HashMap soil : MapUtil.getRawPackageContents(datapackage, (String)"soils")) {
                sidMap.put(MapUtil.getValueOr((Map)soil, (String)"soil_id", (String)""), MapUtil.getValueOr((Map)soil, (String)"sid", (String)""));
            }
            try {
                bw.write(AcmoUtil.generateAcmoHeader());
                ArrayList experiments = MapUtil.getRawPackageContents(datapackage, (String)"experiments");
                for (HashMap experiment : experiments) {
                    String wstId = MapUtil.getValueOr((Map)experiment, (String)"wst_id", (String)"");
                    String soilId = MapUtil.getValueOr((Map)experiment, (String)"soil_id", (String)"");
                    String climId = MapUtil.getValueOr(wstClimMap, (String)wstId, (String)"0XXX");
                    String wid = MapUtil.getValueOr(widMap, (String)wstId, (String)"");
                    String sid = MapUtil.getValueOr(sidMap, (String)soilId, (String)"");
                    String acmoData = AcmoUtil.extractAcmoData(experiment, destModel, domeIdHashMap, climId, wid, sid);
                    log.debug("ACMO dataline: {}", (Object)acmoData);
                    bw.write(acmoData);
                    bw.write("\n");
                }
            }
            finally {
                log.debug("Attempting to close the ACMO file");
                bw.flush();
                bw.close();
                fw.close();
            }
        }
        catch (Exception ex) {
            log.error("Error writing ACMO_meta.dat: {}", (Object)ex.getMessage());
        }
    }

    public static String extractAcmoData(HashMap<String, Object> dataset, String destModel, HashMap<String, String> domeIdHashMap, String ... ids) {
        ArrayList<String> acmoData = new ArrayList<String>();
        HashMap observed = MapUtil.getRawBucket(dataset, (String)"observed");
        HashMap<String, String> events = AcmoUtil.extractEventData(dataset, destModel);
        String climId = "0XXX";
        String wid = "";
        String sid = "";
        if (ids.length > 0) {
            climId = ids[0];
        }
        if (ids.length > 1) {
            wid = ids[1];
        }
        if (ids.length > 2) {
            sid = ids[2];
        }
        String fieldOverlayString = MapUtil.getValueOr(dataset, (String)"field_overlay", (String)"");
        String seasonalStrategyString = MapUtil.getValueOr(dataset, (String)"seasonal_strategy", (String)"");
        ArrayList<HashMap<String, String>> domeBases = new ArrayList<HashMap<String, String>>();
        acmoData.add("*");
        acmoData.add("");
        String exname = MapUtil.getValueOr(dataset, (String)"exname", (String)"");
        acmoData.add(AcmoUtil.quoteMe(exname));
        String doStr = AcmoUtil.getDomeIds(dataset, "field_overlay", "field_dome_applied").toUpperCase();
        String dsStr = AcmoUtil.getDomeIds(dataset, "seasonal_strategy", "seasonal_dome_applied").toUpperCase();
        String drStr = AcmoUtil.getDomeIds(dataset, "rotational_analysis", "rotational_dome_applied").toUpperCase();
        String batStr = AcmoUtil.getDomeIds(dataset, "batch_dome", "batch_dome_applied").toUpperCase();
        String batRunNum = AcmoUtil.getDomeIds(dataset, "batch_run#", "batch_dome_applied").toUpperCase();
        acmoData.add(AcmoUtil.quoteMe(doStr));
        acmoData.add(AcmoUtil.quoteMe(dsStr));
        acmoData.add(AcmoUtil.quoteMe(drStr));
        acmoData.add(AcmoUtil.quoteMe(batStr));
        acmoData.add(AcmoUtil.quoteMe(batRunNum));
        String runNum = "1";
        if (exname.matches(".*__\\d+")) {
            runNum = exname.substring(exname.lastIndexOf("__") + 2);
        }
        acmoData.add(runNum);
        acmoData.add(AcmoUtil.quoteMe(MapUtil.getValueOr(dataset, (String)"trt_name", (String)"")));
        acmoData.add(AcmoUtil.quoteMe(climId));
        acmoData.add("1");
        if (!seasonalStrategyString.equals("")) {
            domeBases.addAll(AcmoUtil.getDomeMetaInfos(seasonalStrategyString));
        }
        domeBases.addAll(AcmoUtil.getDomeMetaInfos(fieldOverlayString));
        acmoData.add(AcmoUtil.quoteMe(AcmoUtil.getDomeMetaInfo(domeBases, "reg_id", "")));
        acmoData.add(AcmoUtil.quoteMe(AcmoUtil.getDomeMetaInfo(domeBases, "stratum", "")));
        acmoData.add(AcmoUtil.getDomeMetaInfo(domeBases, "rap_id", ""));
        acmoData.add(AcmoUtil.getDomeMetaInfo(domeBases, "man_id", ""));
        acmoData.add("AgMIP");
        acmoData.add(MapUtil.getValueOr(dataset, (String)"rotation", (String)"0"));
        String wst_id = MapUtil.getValueOr(dataset, (String)"wst_id", (String)"");
        if (wst_id.length() > 4) {
            wst_id = wst_id.substring(0, 4);
        }
        acmoData.add(wst_id);
        acmoData.add(MapUtil.getValueOr(dataset, (String)"soil_id", (String)""));
        acmoData.add(MapUtil.getValueOr(dataset, (String)"fl_lat", (String)""));
        acmoData.add(MapUtil.getValueOr(dataset, (String)"fl_long", (String)""));
        acmoData.add(AcmoUtil.quoteMe(MapUtil.getValueOr(events, (String)"crid", (String)"")));
        acmoData.add(MapUtil.getValueOr(events, (String)"cul_id", (String)""));
        acmoData.add(AcmoUtil.quoteMe(MapUtil.getValueOr(events, (String)"cul_name", (String)"")));
        acmoData.add(AcmoUtil.correctDateFormat(MapUtil.getValueOr(dataset, (String)"sdat", (String)"")));
        acmoData.add(AcmoUtil.correctDateFormat(MapUtil.getValueOr(events, (String)"pdate", (String)"")));
        acmoData.add(MapUtil.getValueOr((Map)observed, (String)"hwah", (String)""));
        acmoData.add(MapUtil.getValueOr((Map)observed, (String)"cwah", (String)""));
        acmoData.add(AcmoUtil.correctDateFormat(MapUtil.getValueOr((Map)observed, (String)"hdate", (String)"")));
        acmoData.add(MapUtil.getValueOr(events, (String)"ir_count", (String)""));
        acmoData.add(MapUtil.getValueOr(events, (String)"ir_tot", (String)""));
        acmoData.add(AcmoUtil.quoteMe(MapUtil.getValueOr(events, (String)"irop", (String)"")));
        acmoData.add(MapUtil.getValueOr(events, (String)"fe_count", (String)""));
        acmoData.add(MapUtil.getValueOr(events, (String)"fen_tot", (String)""));
        acmoData.add(MapUtil.getValueOr(events, (String)"fep_tot", (String)""));
        acmoData.add(MapUtil.getValueOr(events, (String)"fek_tot", (String)""));
        acmoData.add(MapUtil.getValueOr(events, (String)"omamt", (String)""));
        acmoData.add(MapUtil.getValueOr(events, (String)"ti_count", (String)""));
        acmoData.add(AcmoUtil.quoteMe(MapUtil.getValueOr(events, (String)"tiimp", (String)"")));
        acmoData.add(AcmoUtil.quoteMe(MapUtil.getValueOr(dataset, (String)"eid", (String)"")));
        acmoData.add(AcmoUtil.quoteMe(wid));
        acmoData.add(AcmoUtil.quoteMe(sid));
        acmoData.add(AcmoUtil.quoteMe(AcmoUtil.getDomeHash(domeIdHashMap, doStr)));
        acmoData.add(AcmoUtil.quoteMe(AcmoUtil.getDomeHash(domeIdHashMap, dsStr)));
        acmoData.add(AcmoUtil.quoteMe(AcmoUtil.getDomeHash(domeIdHashMap, drStr)));
        acmoData.add(AcmoUtil.quoteMe(AcmoUtil.getDomeHash(domeIdHashMap, batStr)));
        acmoData.add(destModel.toUpperCase());
        return AcmoUtil.joinList(acmoData, ",");
    }

    private static ArrayList<HashMap<String, String>> getDomeMetaInfos(String domeStr) {
        String[] domes;
        ArrayList<HashMap<String, String>> ret = new ArrayList<HashMap<String, String>>();
        for (String dome : domes = domeStr.split("[|]")) {
            ret.add(DomeUtil.unpackDomeName((String)dome));
        }
        return ret;
    }

    private static String getDomeMetaInfo(ArrayList<HashMap<String, String>> domeBases, String metaId, String defVal) {
        HashMap<String, String> domeBase;
        String ret = "";
        Iterator<HashMap<String, String>> i$ = domeBases.iterator();
        while (i$.hasNext() && (ret = MapUtil.getValueOr(domeBase = i$.next(), (String)metaId, (String)"")).equals("")) {
        }
        if (ret.equals("")) {
            return defVal;
        }
        return ret;
    }

    private static String getDomeIds(HashMap dataset, String domeType, String domeAppliedFlg) {
        if (MapUtil.getValueOr((Map)dataset, (String)domeAppliedFlg, (String)"").equals("Y")) {
            return MapUtil.getValueOr((Map)dataset, (String)domeType, (String)"");
        }
        return "";
    }

    private static String getDomeHash(HashMap<String, String> domeIdHashMap, String domeIds) {
        String[] ids;
        ArrayList<String> domeHashs = new ArrayList<String>();
        for (String id : ids = domeIds.split("\\|")) {
            String hash = MapUtil.getValueOr(domeIdHashMap, (String)id, (String)"");
            if (hash.equals("")) continue;
            domeHashs.add(hash);
        }
        return AcmoUtil.joinList(domeHashs, "|");
    }

    public static String generateAcmoHeader() {
        return "!,\"ID for suite of sites or experiments\",\"Name of experiment, field test or survey\",Field Overlay (DOME) ID,Seaonal Strategy (DOME) ID,Rotational Analysis (DOME) ID,BATCH (DOME) ID,,,Treatment Name,4-character Climate ID code,Climate replication number for multiple realizations of weather data (ask Alex),Region ID,Regional stratum identification number,RAP ID,\"Management regimen ID, for multiple management regimens per RAP\",Names of institutions involved in collection of field or survey data,\"Crop rotation indicator (=1 to indicate that this is a continuous, multi-year simulation, =0 for single year simulations)\",Weather station ID,Soil ID,Site Latitude,Site Longitude,Crop type (common name) ,Crop model-specific cultivar ID,Cultivar name,Start of simulation date,Planting date,\"Observed harvested yield, dry weight\",Observed total above-ground biomass at harvest,Observed harvest date,Total number of irrigation events,Total amount of irrigation,Type of irrigation application,Total number of fertilizer applications,Total N applied,Total P applied,Total K applied,Manure and applied oganic matter,Total number of tillage applications,\"Tillage type (hand, animal or mechanized)\",Experiment ID,Weather ID,Soil ID,DOME ID for Overlay,DOME ID for Seasonal  ,DOME ID for Rotational ,DOME ID for Batch DOME,\"Short name of crop model used for simulations (e.g., DSSAT, APSIM, Aquacrop, STICS, etc.)\",Model name and version number of the crop model used to generate simulated outputs,\"Simulated harvest yield, dry matter\",\"Simulated above-ground biomass at harvest, dry matter\",Simulated anthesis date,Simulated maturity date,Simulated harvest date,\"Simulated leaf area index, maximum\",Total precipitation from planting to harvest,\"Simulated evapotranspiration, planting to harvest\",Simulated N uptake during season,Simulated N leached up to harvest maturity,\"Transpiration, cumulative from planting to harvest\",\"Evaporation,soil, cumulative from planting to harvest\"\n!,text,text,text,text,text,text,number,number,text,code,number,code,number,code,code,text,number,text,text,decimal degrees,decimal degrees,text,text,text,yyyy-mm-dd,yyyy-mm-dd,kg/ha,kg/ha,yyyy-mm-dd,number,mm,text,number,kg[N]/ha,kg[P]/ha,kg[K]/ha,kg/ha,#,text,text,text,text,text,text,text,text,text,text,kg/ha,kg/ha,yyyy-mm-dd,yyyy-mm-dd,yyyy-mm-dd,m2/m2,mm,mm,kg/ha,kg/ha,mm,mm\n#,SUITE_ID,EXNAME,FIELD_OVERLAY,SEASONAL_STRATEGY,ROTATIONAL_ANALYSIS,BATCH_DOME,BATCH_RUN#,RUN#,TRT_NAME,CLIM_ID,CLIM_REP,REG_ID,STRATUM,RAP_ID,MAN_ID,INSTITUTION,ROTATION,WST_ID,SOIL_ID,FL_LAT,FL_LONG,CRID_text,CUL_ID,CUL_NAME,SDAT,PDATE,HWAH,CWAH,HDATE,IR#C,IR_TOT,IROP_text,FE_#,FEN_TOT,FEP_TOT,FEK_TOT,OM_TOT,TI_#,TIIMP_text,EID,WID,SID,DOID,DSID,DRID,BDID,CROP_MODEL,MODEL_VER,HWAH_S,CWAH_S,ADAT_S,MDAT_S,HADAT_S,LAIX_S,PRCP_S,ETCP_S,NUCM_S,NLCM_S,EPCP_S,ESCP_S\n";
    }

    protected static HashMap<String, String> extractEventData(HashMap<String, Object> dataset, String destModel) {
        String om_tot;
        BigDecimal omAmount;
        BigDecimal fepAmount;
        BigDecimal fekAmount;
        BigDecimal fenAmount;
        BigDecimal irrAmount;
        destModel = destModel.toLowerCase();
        HashMap<String, String> results = new HashMap<String, String>();
        HashMap management = MapUtil.getRawBucket(dataset, (String)"management");
        ArrayList events = (ArrayList)MapUtil.getObjectOr((Map)management, (Object)"events", new ArrayList());
        int irrCount = 0;
        int feCount = 0;
        int tilCount = 0;
        ArrayList<String> irop = new ArrayList<String>();
        ArrayList<String> timp = new ArrayList<String>();
        try {
            irrAmount = new BigDecimal(0.0);
            fenAmount = new BigDecimal(0.0);
            fekAmount = new BigDecimal(0.0);
            fepAmount = new BigDecimal(0.0);
            omAmount = new BigDecimal(0.0);
        }
        catch (Exception ex) {
            log.error("Error converting 0.0 to a decimal, hard Java error");
            return new HashMap<String, String>();
        }
        for (HashMap event : events) {
            String currentEvent = MapUtil.getValueOr((Map)event, (String)"event", (String)"");
            log.debug("Current event: {}", (Object)event.toString());
            if (currentEvent.equals("planting")) {
                AcmoUtil.populateEventMap(results, event, "pdate", destModel);
                AcmoUtil.populateEventMap(results, event, "cul_name", destModel);
                if (event.containsKey(destModel + "_cul_id")) {
                    AcmoUtil.populateEventMap(results, event, destModel + "_cul_id", destModel);
                } else {
                    AcmoUtil.populateEventMap(results, event, "cul_id", destModel);
                }
                String crop = LookupCodes.lookupCode((String)"crid", (String)MapUtil.getValueOr((Map)event, (String)"crid", (String)""), (String)"cn");
                results.put("crid", crop);
                continue;
            }
            if (currentEvent.equals("irrigation")) {
                String sIrOp;
                block23: {
                    ++irrCount;
                    String irval = MapUtil.getValueOr((Map)event, (String)"irval", (String)"");
                    sIrOp = LookupCodes.lookupCode((String)"irop", (String)MapUtil.getValueOr((Map)event, (String)"irop", (String)""), (String)"cn");
                    try {
                        if (irval.equals("")) break block23;
                        irrAmount = irrAmount.add(new BigDecimal(irval));
                    }
                    catch (Exception ex) {
                        log.error("Error converting irrigation amount with value {}", (Object)irval);
                        continue;
                    }
                }
                if (irop.contains(sIrOp)) continue;
                irop.add(sIrOp);
                continue;
            }
            if (currentEvent.equals("fertilizer")) {
                String feamp;
                String feamn;
                block25: {
                    String feamk;
                    block24: {
                        ++feCount;
                        feamn = MapUtil.getValueOr((Map)event, (String)"feamn", (String)"");
                        feamk = MapUtil.getValueOr((Map)event, (String)"feamk", (String)"");
                        feamp = MapUtil.getValueOr((Map)event, (String)"feamp", (String)"");
                        log.debug("Feamn amount: {}", (Object)feamn);
                        try {
                            if (feamn.equals("")) break block24;
                            fenAmount = fenAmount.add(new BigDecimal(feamn));
                        }
                        catch (Exception ex) {
                            log.error("Error converting fertilizer [nitrogen] with value {}", (Object)feamn);
                            continue;
                        }
                    }
                    log.debug(fenAmount.toString());
                    try {
                        if (feamk.equals("")) break block25;
                        fekAmount = fekAmount.add(new BigDecimal(feamk));
                    }
                    catch (Exception ex) {
                        log.error("Error converting fertilizer [potassium] with value {}", (Object)feamn);
                        continue;
                    }
                }
                try {
                    if (feamp.equals("")) continue;
                    fepAmount = fepAmount.add(new BigDecimal(feamp));
                }
                catch (Exception ex) {
                    log.error("Error converting fertilizer [phosphorus] with value {}", (Object)feamn);
                }
                continue;
            }
            if (currentEvent.equals("organic_matter")) {
                String omamt = MapUtil.getValueOr((Map)event, (String)"omamt", (String)"");
                if (omamt.equals("")) continue;
                try {
                    omAmount = omAmount.add(new BigDecimal(omamt));
                }
                catch (Exception ex) {
                    log.error("Error converting organic matter amount with value {}", (Object)omamt);
                }
                continue;
            }
            if (!currentEvent.equals("tillage")) continue;
            ++tilCount;
            String tiimp = LookupCodes.lookupCode((String)"tiimp", (String)MapUtil.getValueOr((Map)event, (String)"tiimp", (String)""), (String)"ca");
            if (timp.contains(tiimp)) continue;
            timp.add(tiimp);
        }
        if (irrCount > 0) {
            results.put("ir_count", Integer.toString(irrCount));
            results.put("ir_tot", irrAmount.toString());
            results.put("irop", AcmoUtil.joinList(irop, "|"));
        }
        if (feCount > 0) {
            results.put("fe_count", Integer.toString(feCount));
            results.put("fen_tot", fenAmount.toString());
            results.put("fek_tot", fekAmount.toString());
            results.put("fep_tot", fepAmount.toString());
        }
        if (!(om_tot = omAmount.toString()).equals("0")) {
            results.put("omamt", om_tot);
        }
        if (tilCount > 0) {
            results.put("ti_count", Integer.toString(tilCount));
            results.put("tiimp", AcmoUtil.joinList(timp, "|"));
        }
        log.debug("extractEventData results: {}", (Object)results.toString());
        return results;
    }

    private static void populateEventMap(HashMap<String, String> eventMap, HashMap<String, String> sourceMap, String var, String destModel) {
        String tempVar = AcePathfinderUtil.setEventDateVar((String)var, (boolean)true);
        String value = MapUtil.getValueOr(sourceMap, (String)tempVar, (String)"");
        if (var.startsWith(destModel)) {
            var = var.substring(destModel.length() + 1);
        }
        eventMap.put(var, value);
    }

    private static String joinList(ArrayList<String> list, String joint) {
        StringBuilder joinedList = new StringBuilder();
        for (String item : list) {
            joinedList.append(item);
            joinedList.append(joint);
        }
        if (joinedList.length() > 0) {
            joinedList.setLength(joinedList.length() - 1);
        }
        return joinedList.toString();
    }

    private static String correctDateFormat(String date) {
        if (!date.equals("")) {
            StringBuilder d = new StringBuilder(date);
            d.insert(4, "-");
            d.insert(7, "-");
            return d.toString();
        }
        return date;
    }

    private static String quoteMe(String unquoted) {
        return "\"" + unquoted.replaceAll("\"", "\"\"").replaceAll("\\\\", "\\\\\\\\") + "\"";
    }

    public static File createCsvFile(String outputCsvPath, String mode) {
        return AcmoUtil.createCsvFile(outputCsvPath, mode, null);
    }

    public static File createCsvFile(String outputCsvPath, String model, String metaFilePath) {
        if (!outputCsvPath.endsWith(File.separator) && !outputCsvPath.equals("")) {
            outputCsvPath = outputCsvPath + File.separator;
        }
        String domeInfo = "";
        if (metaFilePath != null) {
            try {
                CSVReader reader = new CSVReader((Reader)new FileReader(metaFilePath), ',', '\"');
                List metaData = reader.readAll();
                reader.close();
                String[] title = new String[]{};
                ArrayList<String[]> dataArr = new ArrayList<String[]>();
                for (int i = 0; i < metaData.size() - 1; ++i) {
                    if ("#".equals(((String[])metaData.get(i))[0])) {
                        title = (String[])metaData.get(i);
                        continue;
                    }
                    if (!"*".equals(((String[])metaData.get(i))[0])) continue;
                    dataArr.add((String[])metaData.get(i));
                }
                int region = -1;
                int stratum = -1;
                int climateId = -1;
                int rapId = -1;
                int mgnId = -1;
                int field = -1;
                int seasonal = -1;
                int count = 0;
                for (int i = 0; i < title.length; ++i) {
                    if ("REG_ID".equalsIgnoreCase(title[i])) {
                        region = i;
                        ++count;
                    } else if ("STRATUM".equalsIgnoreCase(title[i])) {
                        stratum = i;
                        ++count;
                    } else if ("CLIM_ID".equalsIgnoreCase(title[i])) {
                        climateId = i;
                        ++count;
                    } else if ("RAP_ID".equalsIgnoreCase(title[i])) {
                        rapId = i;
                        ++count;
                    } else if ("MAN_ID".equalsIgnoreCase(title[i])) {
                        mgnId = i;
                        ++count;
                    } else if ("FIELD_OVERLAY".equalsIgnoreCase(title[i])) {
                        field = i;
                        ++count;
                    } else {
                        if (!"SEASONAL_STRATEGY".equalsIgnoreCase(title[i])) continue;
                        seasonal = i;
                        ++count;
                    }
                    if (count == 7) break;
                }
                if (!(dataArr.isEmpty() || region == -1 || stratum == -1 && rapId == -1 && mgnId == -1 && climateId == -1)) {
                    String str = AcmoUtil.getDomeInfoStr((String[])dataArr.get(0), region);
                    if (str.equals("0-")) {
                        HashMap domeBase;
                        str = AcmoUtil.getDomeInfoStr((String[])dataArr.get(0), seasonal);
                        if (str.equals("0-") && (str = AcmoUtil.getDomeInfoStr((String[])dataArr.get(0), field)).equals("0-")) {
                            str = "";
                        }
                        if (!"".equals(str) && !(str = MapUtil.getValueOr((Map)(domeBase = DomeUtil.unpackDomeName((String)str)), (String)"reg_id", (String)"")).equals("")) {
                            str = str + "-";
                        }
                    } else if (!str.equals("")) {
                        domeInfo = str;
                        domeInfo = domeInfo + AcmoUtil.getDomeInfoStr(dataArr, stratum);
                        domeInfo = domeInfo + AcmoUtil.getDomeInfoStr(dataArr.get(0), climateId);
                        domeInfo = domeInfo + AcmoUtil.getDomeInfoStr(dataArr, rapId);
                        domeInfo = domeInfo + AcmoUtil.getDomeInfoStr(dataArr, mgnId);
                    }
                }
            }
            catch (IOException ex) {
                domeInfo = "";
            }
        }
        outputCsvPath = outputCsvPath + "ACMO-" + domeInfo + model;
        File f = new File(outputCsvPath + ".csv");
        int count = 1;
        while (f.exists()) {
            f = new File(outputCsvPath + " (" + count + ").csv");
            ++count;
        }
        return f;
    }

    private static String getDomeInfoStr(String[] data, int id) {
        if (id < 0) {
            return "0-";
        }
        if (id < data.length) {
            if ("".equals(data[id])) {
                return "0-";
            }
            return data[id] + "-";
        }
        return "0-";
    }

    private static String getDomeInfoStr(ArrayList<String[]> dataArr, int id) {
        if (id < 0) {
            return "0-";
        }
        if (dataArr.isEmpty()) {
            return "0-";
        }
        String ret = AcmoUtil.getDomeInfoStr(dataArr.get(0), id);
        for (int i = 1; i < dataArr.size(); ++i) {
            String tmp = ret;
            if (tmp.equals(ret = AcmoUtil.getDomeInfoStr(dataArr.get(i), id))) continue;
            return "M-";
        }
        return ret;
    }

    public static String escapeCsvStr(String str) {
        if (str != null && !str.equals("")) {
            boolean needQuote = false;
            if (str.contains("\"")) {
                str = str.replaceAll("\"", "\"\"");
                needQuote = true;
            }
            if (!needQuote && str.contains(",")) {
                needQuote = true;
            }
            if (needQuote) {
                str = "\"" + str + "\"";
            }
            return str;
        }
        return "";
    }
}

