/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.telnet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.function.BiConsumer;
import org.aesh.terminal.TestBase;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.junit.rules.ExternalResource;

public class TelnetClientRule
extends ExternalResource {
    private Socket socket;
    private OutputStream directOutput;
    public TelnetClient client;

    public String assertReadString(int length) throws Exception {
        return new String(this.assertReadBytes(length), 0, length, "UTF-8");
    }

    private void checkNotConnected() {
        if (this.client.isConnected()) {
            throw TestBase.failure((String)"Already connected");
        }
    }

    public TelnetClientRule registerNotifHandler(BiConsumer<Integer, Integer> handler) {
        this.checkNotConnected();
        this.client.registerNotifHandler(handler::accept);
        return this;
    }

    public void setOptionHandler(TelnetOptionHandler handler) throws IOException, InvalidTelnetOptionException {
        this.checkNotConnected();
        this.client.addOptionHandler(handler);
    }

    public TelnetClientRule connect(String host, int port) throws IOException {
        this.checkNotConnected();
        this.client.connect(host, port);
        return this;
    }

    public void disconnect() throws IOException {
        this.disconnect(true);
    }

    public boolean checkDisconnected() {
        try {
            return this.socket != null && this.socket.getInputStream().read() == -1;
        }
        catch (SocketException e) {
            if (e.getMessage().equals("Connection reset")) {
                return true;
            }
            throw TestBase.failure((Throwable)e);
        }
        catch (IOException e) {
            throw TestBase.failure((Throwable)e);
        }
    }

    public void disconnect(boolean clean) throws IOException {
        if (this.client.isConnected()) {
            if (clean) {
                this.client.disconnect();
            } else {
                this.socket.close();
            }
        }
    }

    public byte[] assertReadBytes(int length) throws Exception {
        byte[] bytes = new byte[length];
        while (length > 0) {
            int i = this.client.getInputStream().read(bytes, bytes.length - length, length);
            if (i == -1) {
                throw TestBase.failure((String)"Closed");
            }
            length -= i;
        }
        return bytes;
    }

    public TelnetClientRule write(byte ... bytes) throws IOException {
        this.client.getOutputStream().write(bytes);
        return this;
    }

    public TelnetClientRule flush() throws IOException {
        this.client.getOutputStream().flush();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDirect(byte ... bytes) throws IOException {
        TelnetClient telnetClient = this.client;
        synchronized (telnetClient) {
            this.directOutput.write(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDirectAndFlush(byte ... bytes) throws IOException {
        TelnetClient telnetClient = this.client;
        synchronized (telnetClient) {
            this.directOutput.write(bytes);
            this.directOutput.flush();
        }
    }

    protected void before() throws Throwable {
        this.client = new TelnetClient(){

            protected void _connectAction_() throws IOException {
                super._connectAction_();
                TelnetClientRule.this.socket = this._socket_;
                TelnetClientRule.this.directOutput = this._output_;
                this.setKeepAlive(false);
            }
        };
    }

    protected void after() {
        if (this.client != null && this.client.isConnected()) {
            try {
                this.client.disconnect();
            }
            catch (Exception exception) {
            }
            finally {
                this.client = null;
            }
        }
    }
}

