/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.http.tty;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.aesh.terminal.tty.TtyTestBase;
import org.junit.After;

public abstract class WebsocketTtyTestBase
extends TtyTestBase {
    private Endpoint endpoint;
    private Session session;
    private PipedReader in;

    @After
    public void after() throws Exception {
        if (this.session != null) {
            try {
                this.session.close();
            }
            finally {
                this.in = null;
                this.session = null;
                this.endpoint = null;
            }
        }
    }

    public boolean checkDisconnected() {
        return this.session == null || !this.session.isOpen();
    }

    protected void assertConnect(String term) throws Exception {
        if (this.endpoint != null) {
            throw WebsocketTtyTestBase.failure((String)"Already a session");
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final PipedWriter out = new PipedWriter();
        this.in = new PipedReader(out);
        this.endpoint = new Endpoint(){

            public void onOpen(Session session, EndpointConfig endpointConfig) {
                session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                    public void onMessage(String message) {
                        try {
                            out.write(message);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                latch.countDown();
            }

            public void onClose(Session sess, CloseReason closeReason) {
                WebsocketTtyTestBase.this.session = null;
                WebsocketTtyTestBase.this.endpoint = null;
                WebsocketTtyTestBase.this.in = null;
            }

            public void onError(Session session, Throwable thr) {
            }
        };
        ClientEndpointConfig clientEndpointConfig = ClientEndpointConfig.Builder.create().build();
        WebSocketContainer webSocketContainer = ContainerProvider.getWebSocketContainer();
        this.session = webSocketContainer.connectToServer(this.endpoint, clientEndpointConfig, new URI("http://localhost:8080/ws"));
        latch.await();
    }

    protected void assertWrite(String s) throws Exception {
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("action", "read");
        msg.put("data", s);
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString(msg);
        this.session.getBasicRemote().sendText(json);
    }

    protected String assertReadString(int len) throws Exception {
        char[] buf = new char[len];
        while (len > 0) {
            int count = this.in.read(buf, buf.length - len, len);
            if (count == -1) {
                throw WebsocketTtyTestBase.failure((String)"Could not read enough");
            }
            len -= count;
        }
        return new String(buf);
    }

    protected void assertWriteln(String s) throws Exception {
        this.assertWrite(s + "\r");
    }

    protected void assertDisconnect(boolean clean) throws Exception {
        if (clean) {
            this.session.close();
        } else {
            this.session.close();
        }
    }

    protected void resize(int width, int height) throws Exception {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("action", "resize");
        msg.put("cols", width);
        msg.put("rows", height);
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString(msg);
        this.session.getBasicRemote().sendText(json);
    }

    public void testDifferentCharset() throws Exception {
    }
}

