/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal.impl;

import java.io.IOError;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.readline.terminal.impl.SignalHandlers;
import org.aesh.readline.terminal.utils.Curses;
import org.aesh.readline.terminal.utils.InfoCmp;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Terminal;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Signal;
import org.aesh.util.Config;
import org.aesh.util.LoggerUtil;

public abstract class AbstractTerminal
implements Terminal {
    protected final Logger LOGGER = LoggerUtil.getLogger(this.getClass().getName());
    protected final String name;
    protected final String type;
    protected final Map<Signal, Terminal.SignalHandler> handlers = new HashMap<Signal, Terminal.SignalHandler>();
    protected final Set<Capability> bools = new HashSet<Capability>();
    protected final Map<Capability, Integer> ints = new HashMap<Capability, Integer>();
    protected final Map<Capability, String> strings = new HashMap<Capability, String>();

    public AbstractTerminal(String name, String type) throws IOException {
        this(name, type, SignalHandlers.SIG_DFL);
    }

    public AbstractTerminal(String name, String type, Terminal.SignalHandler signalHandler) throws IOException {
        this.name = name;
        this.type = type;
        for (Signal signal : Signal.values()) {
            this.handlers.put(signal, signalHandler);
        }
    }

    @Override
    public Terminal.SignalHandler handle(Signal signal, Terminal.SignalHandler handler) {
        assert (signal != null);
        assert (handler != null);
        return this.handlers.put(signal, handler);
    }

    @Override
    public void raise(Signal signal) {
        assert (signal != null);
        Terminal.SignalHandler handler = this.handlers.get((Object)signal);
        if (handler == SignalHandlers.SIG_DFL) {
            this.handleDefaultSignal(signal);
        } else if (handler != SignalHandlers.SIG_IGN) {
            handler.handle(signal);
        }
    }

    protected void handleDefaultSignal(Signal signal) {
    }

    protected void echoSignal(Signal signal) {
        int vcc;
        Attributes.ControlChar cc = null;
        switch (signal) {
            case INT: {
                cc = Attributes.ControlChar.VINTR;
                break;
            }
            case QUIT: {
                cc = Attributes.ControlChar.VQUIT;
                break;
            }
            case TSTP: {
                cc = Attributes.ControlChar.VSUSP;
            }
        }
        if (cc != null && (vcc = this.getAttributes().getControlChar(cc)) > 0 && vcc < 32) {
            this.writer().write(new char[]{'^', (char)(vcc + 64)}, 0, 2);
        }
    }

    @Override
    public Attributes enterRawMode() {
        Attributes prvAttr = this.getAttributes();
        Attributes newAttr = new Attributes(prvAttr);
        newAttr.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.IEXTEN), false);
        newAttr.setInputFlags(EnumSet.of(Attributes.InputFlag.IXON, Attributes.InputFlag.ICRNL, Attributes.InputFlag.INLCR), false);
        newAttr.setControlChar(Attributes.ControlChar.VMIN, 1);
        newAttr.setControlChar(Attributes.ControlChar.VTIME, 0);
        this.setAttributes(newAttr);
        return prvAttr;
    }

    @Override
    public boolean echo() {
        return this.getAttributes().getLocalFlag(Attributes.LocalFlag.ECHO);
    }

    @Override
    public boolean echo(boolean echo) {
        Attributes attr = this.getAttributes();
        boolean prev = attr.getLocalFlag(Attributes.LocalFlag.ECHO);
        if (prev != echo) {
            attr.setLocalFlag(Attributes.LocalFlag.ECHO, echo);
            this.setAttributes(attr);
        }
        return prev;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void flush() {
        this.writer().flush();
    }

    @Override
    public boolean puts(Capability capability, Object ... params) {
        String str = this.getStringCapability(capability);
        if (str == null) {
            return false;
        }
        try {
            Curses.tputs(this.writer(), str, params);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return true;
    }

    @Override
    public boolean getBooleanCapability(Capability capability) {
        return this.bools.contains((Object)capability);
    }

    @Override
    public Integer getNumericCapability(Capability capability) {
        return this.ints.get((Object)capability);
    }

    @Override
    public String getStringCapability(Capability capability) {
        return this.strings.get((Object)capability);
    }

    void parseInfoCmp() {
        String capabilities = null;
        if (this.type != null && Config.isOSPOSIXCompatible()) {
            try {
                capabilities = InfoCmp.getInfoCmp(this.type);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, "Unable to retrieve infocmp for type " + this.type, e);
            }
        }
        if (capabilities == null) {
            capabilities = Config.isOSPOSIXCompatible() ? InfoCmp.getDefaultInfoCmp("ansi") : InfoCmp.getDefaultInfoCmp("windows");
        }
        InfoCmp.parseInfoCmp(capabilities, this.bools, this.ints, this.strings);
    }
}

