/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.action.mappings;

import org.aesh.readline.ConsoleBuffer;
import org.aesh.readline.InputProcessor;
import org.aesh.readline.action.Action;
import org.aesh.util.Config;
import org.aesh.util.Parser;

public class Enter
implements Action {
    private static final String ENDS_WITH_BACKSLASH = "\\";
    private static final String HASHTAG = "#";

    @Override
    public String name() {
        return "accept-line";
    }

    @Override
    public void accept(InputProcessor inputProcessor) {
        ConsoleBuffer consoleBuffer = inputProcessor.getBuffer();
        consoleBuffer.undoManager().clear();
        boolean isCurrentLineEnding = true;
        if (!consoleBuffer.buffer().isMasking()) {
            String buffer = consoleBuffer.buffer().asString().trim();
            if (buffer.startsWith(HASHTAG)) {
                consoleBuffer.buffer().reset();
                inputProcessor.getBuffer().writeOut(Config.CR);
                isCurrentLineEnding = false;
            } else if (buffer.endsWith(ENDS_WITH_BACKSLASH)) {
                consoleBuffer.buffer().setMultiLine(true);
                consoleBuffer.buffer().updateMultiLineBuffer();
                inputProcessor.getBuffer().writeOut(Config.CR);
                isCurrentLineEnding = false;
            } else if (Parser.doesStringContainOpenQuote(buffer)) {
                consoleBuffer.buffer().setMultiLine(true);
                consoleBuffer.buffer().updateMultiLineBuffer();
                inputProcessor.getBuffer().writeOut(Config.CR);
                isCurrentLineEnding = false;
            } else if (inputProcessor.getBuffer().history().isEnabled()) {
                if (consoleBuffer.buffer().isMultiLine()) {
                    inputProcessor.getBuffer().history().push(consoleBuffer.buffer().multiLine());
                } else {
                    inputProcessor.getBuffer().history().push(consoleBuffer.buffer().multiLine());
                }
            }
        }
        if (isCurrentLineEnding) {
            consoleBuffer.moveCursor(consoleBuffer.buffer().length());
        }
        if (isCurrentLineEnding) {
            inputProcessor.setReturnValue(consoleBuffer.buffer().multiLine());
            consoleBuffer.buffer().reset();
        } else {
            consoleBuffer.drawLine();
        }
    }
}

