/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.action.mappings;

import java.util.Arrays;
import org.aesh.readline.ConsoleBuffer;
import org.aesh.readline.InputProcessor;
import org.aesh.readline.action.Action;

public class DeletePrevChar
implements Action {
    @Override
    public String name() {
        return "backward-delete-char";
    }

    @Override
    public void accept(InputProcessor inputProcessor) {
        if (inputProcessor.getBuffer().buffer().isMasking() && inputProcessor.getBuffer().buffer().prompt().getMask().charValue() == '\u0000') {
            this.deleteWithMaskEnabled(inputProcessor.getBuffer());
            return;
        }
        this.deleteNoMasking(inputProcessor.getBuffer());
    }

    private void deleteNoMasking(ConsoleBuffer consoleBuffer) {
        int cursor = consoleBuffer.buffer().cursor();
        if (cursor > 0) {
            int lineSize = consoleBuffer.buffer().length();
            if (cursor > lineSize) {
                cursor = lineSize;
            }
            consoleBuffer.addActionToUndoStack();
            consoleBuffer.pasteManager().addText(Arrays.copyOfRange(consoleBuffer.buffer().multiLine(), cursor - 1, cursor));
            consoleBuffer.delete(-1);
        }
    }

    private void deleteWithMaskEnabled(ConsoleBuffer consoleBuffer) {
        if (consoleBuffer.buffer().length() > 0) {
            consoleBuffer.delete(-1);
            consoleBuffer.moveCursor(consoleBuffer.buffer().length());
        }
    }
}

