/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import org.aesh.readline.AeshConsoleBuffer;
import org.aesh.readline.ConsoleBuffer;
import org.aesh.readline.InputProcessor;
import org.aesh.readline.Prompt;
import org.aesh.readline.action.Action;
import org.aesh.readline.action.ActionDecoder;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.completion.CompletionHandler;
import org.aesh.readline.completion.SimpleCompletionHandler;
import org.aesh.readline.editing.EditMode;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.history.History;
import org.aesh.readline.history.InMemoryHistory;
import org.aesh.terminal.Key;
import org.aesh.tty.Connection;
import org.aesh.tty.Signal;
import org.aesh.tty.Size;
import org.aesh.util.Config;
import org.aesh.util.LoggerUtil;
import org.aesh.util.Parser;

public class Readline {
    private static final Logger LOGGER = LoggerUtil.getLogger(Readline.class.getName());
    private final ActionDecoder decoder;
    private AeshInputProcessor inputProcessor;
    private Size size;
    private CompletionHandler completionHandler;
    private EditMode editMode;
    private History history;

    public Readline() {
        this(EditModeBuilder.builder().create());
    }

    public Readline(EditMode editMode) {
        this(editMode, new InMemoryHistory(), null);
        this.history.enable();
    }

    public Readline(EditMode editMode, History history, CompletionHandler completionHandler) {
        this.editMode = editMode;
        this.history = history;
        this.completionHandler = completionHandler == null ? new SimpleCompletionHandler() : completionHandler;
        this.decoder = new ActionDecoder(this.editMode);
    }

    protected InputProcessor getInputProcessor() {
        return this.inputProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInput() {
        Readline readline = this;
        synchronized (readline) {
            while (this.decoder.hasNext() && this.inputProcessor != null && !this.inputProcessor.paused) {
                this.inputProcessor.parse(this.decoder.next());
            }
            return;
        }
    }

    public void readline(Connection conn, String prompt, Consumer<String> requestHandler) {
        this.readline(conn, new Prompt(prompt), requestHandler, null);
    }

    public void readline(Connection conn, String prompt, Consumer<String> requestHandler, List<Completion> completions) {
        this.readline(conn, new Prompt(prompt), requestHandler, completions);
    }

    public void readline(Connection conn, Prompt prompt, Consumer<String> requestHandler) {
        this.readline(conn, prompt, requestHandler, null);
    }

    public void readline(Connection conn, Prompt prompt, Consumer<String> requestHandler, List<Completion> completions) {
        this.readline(conn, prompt, requestHandler, completions, null);
    }

    public void readline(Connection conn, Prompt prompt, Consumer<String> requestHandler, List<Completion> completions, List<Function<String, Optional<String>>> preProcessors) {
        this.readline(conn, prompt, requestHandler, completions, preProcessors, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readline(Connection conn, Prompt prompt, Consumer<String> requestHandler, List<Completion> completions, List<Function<String, Optional<String>>> preProcessors, History history) {
        Readline readline = this;
        synchronized (readline) {
            if (this.inputProcessor != null) {
                throw new IllegalStateException("Already reading a line");
            }
            this.inputProcessor = new AeshInputProcessor(conn, prompt, requestHandler, completions, preProcessors, history);
        }
        this.inputProcessor.start();
        this.processInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInput() {
        Readline readline = this;
        synchronized (readline) {
            if (this.inputProcessor == null) {
                throw new IllegalStateException("No inputProcessor!");
            }
            if (this.inputProcessor.connection().suspended()) {
                this.inputProcessor.connection().awake();
            }
            if (this.decoder.hasNext()) {
                this.readInput();
            }
        }
    }

    private class AeshInputProcessor
    implements InputProcessor {
        private final Connection conn;
        private Consumer<int[]> prevReadHandler;
        private Consumer<Size> prevSizeHandler;
        private Consumer<Signal> prevEventHandler;
        private final Consumer<String> requestHandler;
        private boolean paused;
        private final ConsoleBuffer consoleBuffer;
        private String returnValue;
        private List<Function<String, Optional<String>>> preProcessors;

        private AeshInputProcessor(Connection conn, Prompt prompt, Consumer<String> requestHandler, List<Completion> completions, List<Function<String, Optional<String>>> preProcessors, History newHistory) {
            Readline.this.completionHandler.clear();
            Readline.this.completionHandler.addCompletions(completions);
            this.consoleBuffer = new AeshConsoleBuffer(conn, prompt, Readline.this.editMode, newHistory != null ? newHistory : Readline.this.history, Readline.this.completionHandler, Readline.this.size, true);
            this.conn = conn;
            this.requestHandler = requestHandler;
            this.preProcessors = preProcessors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finish(String s) {
            this.conn.setStdinHandler(this.prevReadHandler);
            this.conn.setSizeHandler(this.prevSizeHandler);
            this.conn.setSignalHandler(this.prevEventHandler);
            Readline readline = Readline.this;
            synchronized (readline) {
                Readline.this.inputProcessor = null;
            }
            this.requestHandler.accept(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parse(KeyAction event) {
            if (event.length() == 1 && event.getCodePointAt(0) == 4 && this.getBuffer().getBuffer().length() == 0) {
                this.finish(null);
                return;
            }
            Action action = Readline.this.editMode.parse(event);
            if (action != null) {
                Readline readline = Readline.this;
                synchronized (readline) {
                    this.paused = true;
                }
                action.accept(this);
                if (this.getReturnValue() != null) {
                    this.conn.stdoutHandler().accept(Config.CR);
                    this.finish(this.getReturnValue());
                } else {
                    readline = Readline.this;
                    synchronized (readline) {
                        this.paused = false;
                    }
                    Readline.this.processInput();
                }
            } else if (Key.isPrintable(event.buffer()) && this.notInCommandNode()) {
                this.getBuffer().writeChar((char)event.buffer().array()[0]);
            }
        }

        private boolean notInCommandNode() {
            return Readline.this.editMode.getMode() != EditMode.Mode.VI || Readline.this.editMode.getStatus() != EditMode.Status.COMMAND;
        }

        private void start() {
            this.prevReadHandler = this.conn.getStdinHandler();
            this.prevSizeHandler = this.conn.getSizeHandler();
            this.prevEventHandler = this.conn.getSignalHandler();
            this.conn.setStdinHandler(data -> {
                Readline readline = Readline.this;
                synchronized (readline) {
                    Readline.this.decoder.add((int[])data);
                }
                Readline.this.readInput();
            });
            Readline.this.size = this.conn.size();
            if (Readline.this.size == null) {
                throw new RuntimeException("Terminal size must not be null");
            }
            this.consoleBuffer.setSize(Readline.this.size);
            this.conn.setSizeHandler(dim -> {
                if (Readline.this.size != null) {
                    this.resize((Size)dim);
                }
                Readline.this.size = dim;
            });
            if (this.conn.getSignalHandler() == null) {
                this.conn.setSignalHandler(signal -> {
                    if (signal == Signal.INT) {
                        if (Readline.this.editMode.isInChainedAction()) {
                            this.parse(Key.CTRL_C);
                        } else {
                            this.conn.stdoutHandler().accept(new int[]{94, 67});
                            this.conn.stdoutHandler().accept(Config.CR);
                            this.getBuffer().getBuffer().reset();
                            this.consoleBuffer.drawLine();
                        }
                    }
                });
            }
            this.consoleBuffer.drawLine();
        }

        private void resize(Size size) {
            this.consoleBuffer.setSize(size);
            this.consoleBuffer.drawLine();
        }

        @Override
        public String getReturnValue() {
            return this.returnValue;
        }

        @Override
        public ConsoleBuffer getBuffer() {
            return this.consoleBuffer;
        }

        @Override
        public void setReturnValue(int[] in) {
            String input = Parser.fromCodePoints(in);
            if (this.preProcessors != null && this.preProcessors.size() > 0) {
                this.preProcessors.forEach(pre -> ((Optional)pre.apply(input)).ifPresent(v -> {
                    this.returnValue = v;
                }));
            }
            if (this.returnValue == null) {
                this.returnValue = input;
            }
        }

        @Override
        public EditMode getEditMode() {
            return Readline.this.editMode;
        }

        @Override
        public Connection connection() {
            return this.conn;
        }
    }
}

