/*
 * Decompiled with CFR 0.152.
 */
package org.aaa4j.radius.server;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.aaa4j.radius.core.packet.Packet;
import org.aaa4j.radius.server.DuplicationStrategy;

public final class TimedDuplicationStrategy
implements DuplicationStrategy {
    private final Map<CacheKey, CacheValue> cacheMap = new LinkedHashMap<CacheKey, CacheValue>();
    private final long ttlMillis;

    public TimedDuplicationStrategy(Duration ttlDuration) {
        this.ttlMillis = ttlDuration.toMillis();
    }

    @Override
    public synchronized DuplicationStrategy.Result handleRequest(InetSocketAddress clientAddress, Packet requestPacket, byte[] requestPacketBytes) {
        Map.Entry<CacheKey, CacheValue> entry;
        long currentEpochMillis = Instant.now().toEpochMilli();
        Iterator<Map.Entry<CacheKey, CacheValue>> cacheMapIterator = this.cacheMap.entrySet().iterator();
        while (cacheMapIterator.hasNext() && (entry = cacheMapIterator.next()).getValue().insertionEpochMillis + this.ttlMillis < currentEpochMillis) {
            cacheMapIterator.remove();
        }
        CacheKey cacheKey = new CacheKey(clientAddress, requestPacketBytes);
        if (!this.cacheMap.containsKey(cacheKey)) {
            this.cacheMap.put(cacheKey, new CacheValue(currentEpochMillis, requestPacket));
            return new DuplicationStrategy.Result(DuplicationStrategy.Result.State.NEW_REQUEST, null);
        }
        CacheValue cacheValue = this.cacheMap.get(cacheKey);
        if (cacheValue.responsePacket != null) {
            return new DuplicationStrategy.Result(DuplicationStrategy.Result.State.CACHED_RESPONSE, cacheValue.responsePacket);
        }
        return new DuplicationStrategy.Result(DuplicationStrategy.Result.State.IN_PROGRESS_REQUEST, null);
    }

    @Override
    public synchronized void handleResponse(InetSocketAddress clientAddress, Packet requestPacket, byte[] requestPacketBytes, Packet responsePacket) {
        CacheKey cacheKey = new CacheKey(clientAddress, requestPacketBytes);
        if (!this.cacheMap.containsKey(cacheKey)) {
            return;
        }
        CacheValue cacheValue = this.cacheMap.get(cacheKey);
        if (!Arrays.equals(cacheValue.requestPacket.getReceivedFields().getAuthenticator(), requestPacket.getReceivedFields().getAuthenticator())) {
            return;
        }
        cacheValue.responsePacket = responsePacket;
    }

    @Override
    public synchronized void unhandleRequest(InetSocketAddress clientAddress, Packet requestPacket, byte[] requestPacketBytes) {
        CacheKey cacheKey = new CacheKey(clientAddress, requestPacketBytes);
        if (!this.cacheMap.containsKey(cacheKey)) {
            return;
        }
        CacheValue cacheValue = this.cacheMap.get(cacheKey);
        if (!Arrays.equals(cacheValue.requestPacket.getReceivedFields().getAuthenticator(), requestPacket.getReceivedFields().getAuthenticator())) {
            return;
        }
        this.cacheMap.remove(cacheKey);
    }

    private static class CacheValue {
        private final long insertionEpochMillis;
        private final Packet requestPacket;
        private Packet responsePacket;

        private CacheValue(long insertionEpochMillis, Packet requestPacket) {
            this.insertionEpochMillis = insertionEpochMillis;
            this.requestPacket = requestPacket;
        }
    }

    private static class CacheKey {
        private final InetSocketAddress clientAddress;
        private final byte[] requestBytes;

        private CacheKey(InetSocketAddress clientAddress, byte[] requestBytes) {
            this.clientAddress = clientAddress;
            this.requestBytes = requestBytes;
        }

        public int hashCode() {
            return Objects.hash(this.clientAddress, Arrays.hashCode(this.requestBytes));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)obj;
            return Objects.equals(this.clientAddress, cacheKey.clientAddress) && Arrays.equals(this.requestBytes, cacheKey.requestBytes);
        }
    }
}

