/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.velocity.ast;

import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;

final class NodeUtils {
    private NodeUtils() {
    }

    private static StringBuilder getSpecialText(JavaccToken t) {
        StringBuilder sb = new StringBuilder();
        JavaccToken tmpToken = t.getPreviousComment();
        while (tmpToken.getPreviousComment() != null) {
            tmpToken = tmpToken.getPreviousComment();
        }
        while (tmpToken != null) {
            String st = tmpToken.getImage();
            for (int i = 0; i < st.length(); ++i) {
                int j;
                char c = st.charAt(i);
                if (c == '#' || c == '$') {
                    sb.append(c);
                }
                if (c != '\\') continue;
                boolean ok = true;
                boolean term = false;
                ok = true;
                for (j = i; ok && j < st.length(); ++j) {
                    char cc = st.charAt(j);
                    if (cc == '\\') continue;
                    if (cc == '$') {
                        term = true;
                        ok = false;
                        continue;
                    }
                    ok = false;
                }
                if (!term) continue;
                String foo = st.substring(i, j);
                sb.append(foo);
                i = j;
            }
            tmpToken = tmpToken.next;
        }
        return sb;
    }

    static String tokenLiteral(JavaccToken t) {
        if (t.kind == 28) {
            return "";
        }
        if (t.getPreviousComment() == null || t.getPreviousComment().getImage().startsWith("##")) {
            return t.getImage();
        }
        StringBuilder special = NodeUtils.getSpecialText(t);
        if (special.length() > 0) {
            return special.append(t.getImage()).toString();
        }
        return t.getImage();
    }
}

